using System;
using System.Collections.Generic;
using System.Text;

namespace TFTPUtil
{
    /// <summary>
    /// A delegate for the TFTP server event handler
    /// </summary>
    /// <param name="sender">An object representing the sender of the event</param>
    /// <param name="e">The event arguments</param>
    public delegate void TFTPServerEventHandler(object sender, TFTPServerEventArgs e);

    /// <summary>
    /// A class specifying the arguments for the TFTP server event
    /// </summary>
    public class TFTPServerEventArgs : EventArgs
    {
        private string DisplayString;

        /// <summary>
        /// A class that defines the TFTP server event arguments
        /// </summary>
        /// <param name="EventString">The event message to display</param>
        public TFTPServerEventArgs(string EventString)
        {
            this.DisplayString = EventString;
        }

        /// <summary>
        /// Gets the event message to display
        /// </summary>
        public string EventString
        {
            get
            {
                return DisplayString;
            }
        }
    }
}
