﻿using System.ServiceProcess;
using System;
using System.Runtime.InteropServices;

namespace tftpUtilSvcSettings
{
    public static class tftpUtilSvcConsts
    {
        public const string serviceName = "tftpUtilSvc1";
        public const string serviceDisplayName = "tftpUtilSvc1";
        public static string getServicePath()
        {
            string sPath="";
            string AppPath;
            AppPath = System.IO.Path.GetDirectoryName(
                     System.Reflection.Assembly.GetAssembly(typeof(tftpUtilSvcConsts)).CodeBase);
            //AppPath = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase);
            if (!AppPath.EndsWith(@"\"))
                AppPath += @"\";
            sPath = sPath + "tftpUtilSvc.exe";
//#if DEBUG
            sPath = @"D:\C-Source\test\tftpUtilSvc\bin\Debug\tftpUtilSvc1.exe";
//#endif
            return sPath;
        }
    }
    public static class myServiceControl
    {
        public static bool StartService(string serviceName, int timeoutMilliseconds)
        {
            ServiceController service = new ServiceController(serviceName);
            try
            {
                TimeSpan timeout = TimeSpan.FromMilliseconds(timeoutMilliseconds);

                service.Start();
                service.WaitForStatus(ServiceControllerStatus.Running, timeout);
                if(service.Status==ServiceControllerStatus.Running)
                    return true;
                else
                    return false;
            }
            catch
            {
                return false;
            }
        }
        public static bool StopService(string serviceName, int timeoutMilliseconds)
        {
            ServiceController service = new ServiceController(serviceName);
            try
            {
                TimeSpan timeout = TimeSpan.FromMilliseconds(timeoutMilliseconds);

                service.Stop();
                service.WaitForStatus(ServiceControllerStatus.Stopped, timeout);
                if(service.Status==ServiceControllerStatus.Stopped)
                    return true;
                else
                    return false;
            }
            catch
            {
                return false;
            }
        }
        public static bool RestartService(string serviceName, int timeoutMilliseconds)
        {
            ServiceController service = new ServiceController(serviceName);
            try
            {
                int millisec1 = Environment.TickCount;
                TimeSpan timeout = TimeSpan.FromMilliseconds(timeoutMilliseconds);

                service.Stop();
                service.WaitForStatus(ServiceControllerStatus.Stopped, timeout);

                // count the rest of the timeout
                int millisec2 = Environment.TickCount;
                timeout = TimeSpan.FromMilliseconds(timeoutMilliseconds - (millisec2 - millisec1));

                service.Start();
                service.WaitForStatus(ServiceControllerStatus.Running, timeout);
                if (service.Status == ServiceControllerStatus.Running)
                    return true;
                else
                    return false;
            }
            catch
            {
                return false;
            }
        }
        public static bool IsServiceRunning(string serviceName)
        {
            ServiceController service = new ServiceController(serviceName);
            try
            {
                if (service.Status == ServiceControllerStatus.Running)
                    return true;
                else
                    return false;
            }
            catch
            {
                return false;
            }

        }
        public static bool IsServiceInstalled(string serviceName)
        {
          // get list of Windows services
          ServiceController[] services = ServiceController.GetServices();

          // try to find service name
          foreach (ServiceController service in services)
          {
            if (service.ServiceName == serviceName)
              return true;
          }
          return false;
        }

    }
    public static class myServiceInstaller
    {
        #region Private Variables
        private static string _servicePath;
        private static string _serviceName;
        private static string _serviceDisplayName;
        #endregion Private Variables
        #region DLLImport
            [DllImport("advapi32.dll")]
            private static extern IntPtr OpenSCManager(string lpMachineName,string lpSCDB, int scParameter);
            [DllImport("Advapi32.dll", SetLastError = true)]
            private static extern IntPtr CreateService(IntPtr SC_HANDLE,string lpSvcName,string lpDisplayName,
            int dwDesiredAccess,int dwServiceType,int dwStartType,int dwErrorControl,string lpPathName,
            string lpLoadOrderGroup,int lpdwTagId,string lpDependencies,string lpServiceStartName,string lpPassword);
            [DllImport("advapi32.dll")]
            private static extern void CloseServiceHandle(IntPtr SCHANDLE);
            [DllImport("advapi32.dll")]
            private static extern int StartService(IntPtr SVHANDLE,int dwNumServiceArgs,string lpServiceArgVectors);
            [DllImport("advapi32.dll",SetLastError=true)]
            private static extern IntPtr OpenService(IntPtr SCHANDLE,string lpSvcName,int dwNumServiceArgs);
            [DllImport("advapi32.dll")]
            private static extern int DeleteService(IntPtr SVHANDLE);
            [DllImport("kernel32.dll")]
            private static extern int GetLastError();
        #endregion DLLImport
        ///// <summary>
        ///// The main entry point for the application.
        ///// </summary>
        //#region Main method + testing code
        //[STAThread]
        //static void Main(string[] args)
        //{
        //// TODO: Add code to start application here
        //#region Testing
        //// Testing --------------
        //string svcPath;
        //string svcName;
        //string svcDispName;
        ////path to the service that you want to install
        //svcPath = @"C:\build\service\Debug\Service.exe";
        //svcDispName="Service Display Name";
        //svcName= "Service Name";
        //ServiceInstaller c = new ServiceInstaller();
        //c.InstallService(svcPath, svcName, svcDispName);
        //Console.Read();
        //Testing --------------
        //#endregion Testing
        //}
        //#endregion Main method + testing code - Commented
        /// <summary>
        /// This method installs and runs the service in the service control manager.
        /// </summary>
        /// <param name="svcPath">The complete path of the service.</param>
        /// <param name="svcName">Name of the service.</param>
        /// <param name="svcDispName">Display name of the service.</param>
        /// <returns>True if the process went thro successfully. False if there was any error.</returns>
        public static bool InstallService(string svcPath, string svcName, string svcDispName)
        {
            #region Constants declaration.
            int SC_MANAGER_CREATE_SERVICE = 0x0002;
            int SERVICE_WIN32_OWN_PROCESS = 0x00000010;
            //int SERVICE_DEMAND_START = 0x00000003;
            int SERVICE_ERROR_NORMAL = 0x00000001;
            int STANDARD_RIGHTS_REQUIRED = 0xF0000;
            int SERVICE_QUERY_CONFIG = 0x0001;
            int SERVICE_CHANGE_CONFIG = 0x0002;
            int SERVICE_QUERY_STATUS = 0x0004;
            int SERVICE_ENUMERATE_DEPENDENTS = 0x0008;
            int SERVICE_START =0x0010;
            int SERVICE_STOP =0x0020;
            int SERVICE_PAUSE_CONTINUE =0x0040;
            int SERVICE_INTERROGATE =0x0080;
            int SERVICE_USER_DEFINED_CONTROL =0x0100;
            int SERVICE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED |
            SERVICE_QUERY_CONFIG |
            SERVICE_CHANGE_CONFIG |
            SERVICE_QUERY_STATUS |
            SERVICE_ENUMERATE_DEPENDENTS |
            SERVICE_START |
            SERVICE_STOP |
            SERVICE_PAUSE_CONTINUE |
            SERVICE_INTERROGATE |
            SERVICE_USER_DEFINED_CONTROL);
            int SERVICE_AUTO_START = 0x00000002;
            #endregion Constants declaration.
            try
            {
                IntPtr sc_handle = OpenSCManager(null,null,SC_MANAGER_CREATE_SERVICE);
                if (sc_handle.ToInt32() != 0)
                {
                    IntPtr sv_handle = CreateService(sc_handle,
                        svcName,
                        svcDispName,
                        SERVICE_ALL_ACCESS,
                        SERVICE_WIN32_OWN_PROCESS, 
                        SERVICE_AUTO_START,
                        SERVICE_ERROR_NORMAL,
                        svcPath,null,0,null,null,null);
                    if(sv_handle.ToInt32() ==0)
                    {
                        int iErr = Marshal.GetLastWin32Error();
                        //0x00000436 = ERROR_DUPLICATE_SERVICE_NAME
                        System.Diagnostics.Debug.WriteLine("CreateService returned NULL, service name unknown! GetLastError=0x"+iErr.ToString("x"));
                        CloseServiceHandle(sc_handle);
                        switch (iErr)
                        {
                            case 0x0436:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_DUPLICATE_SERVICE_NAME' in CreateService!");
                                break;
                            case 0x0005:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_ACCESS_DENIED' in CreateService!");
                                break;
                            case 0x00000423:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_CIRCULAR_DEPENDENCY' in CreateService!");
                                break;
                            case 0x0006:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_INVALID_HANDLE' in CreateService!");
                                break;
                            case 0x007b:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_INVALID_NAME' in CreateService!");
                                break;
                            case 0x0057:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_INVALID_PARAMETER' in CreateService!");
                                break;
                            case 0x00000421:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_INVALID_SERVICE_ACCOUNT' in CreateService!");
                                break;
                            case 0x0431:
                                System.Windows.Forms.MessageBox.Show("Error 'ERROR_SERVICE_EXISTS' in CreateService!");
                                break;
                        }
                        return false;
                    }
                    else
                    {
                        System.Diagnostics.Debug.WriteLine("Service installed. Trying to start...");
                        //
                        //now trying to start the service
                        if (myServiceControl.StartService(svcName, 10000))
                        {
                            System.Diagnostics.Debug.WriteLine("Service started.");
                            CloseServiceHandle(sc_handle);
                            return true;
                        }
                        else
                        {
                            System.Diagnostics.Debug.WriteLine("Service could not be started.");
                            CloseServiceHandle(sc_handle);
                            return false;
                        }
                        ////now trying to start the service
                        //int i = StartService(sv_handle,0,null);
                        //// If the value i is zero, then there was an error starting the service.
                        //// note: error may arise if the service is already running or some other problem.
                        //if(i==0)
                        //{
                        //    System.Diagnostics.Debug.WriteLine("Could not start service, code: "+i.ToString());
                        //    return false;
                        //}
                        //System.Diagnostics.Debug.WriteLine("Success");
                        //CloseServiceHandle(sc_handle);
                        //return true;
                    }
                }
                else
                    System.Diagnostics.Debug.WriteLine("SCM not opened successfully");
                    return false;
            }
            catch(Exception e)
            {
                System.Diagnostics.Debug.WriteLine("Exception in StartService():" +e.Message);
                return false;
            }
        }
        /// <summary>
        /// This method uninstalls the service from the service conrol manager.
        /// </summary>
        /// <param name="svcName">Name of the service to uninstall.</param>
        public static bool UnInstallService(string svcName)
        {
            int GENERIC_WRITE = 0x40000000;
            IntPtr sc_hndl = OpenSCManager(null,null,GENERIC_WRITE);
            if (sc_hndl.ToInt32() != 0)
            {
                int DELETE = 0x10000;
                IntPtr svc_hndl = OpenService(sc_hndl, svcName, DELETE);
                System.Diagnostics.Debug.WriteLine(svc_hndl.ToInt32());
                if (svc_hndl.ToInt32() != 0)
                {
                    int i = DeleteService(svc_hndl);
                    if (i != 0)
                    {
                        CloseServiceHandle(sc_hndl);
                        System.Diagnostics.Debug.WriteLine("DeleteService SUCCESS");
                        return true;
                    }
                    else
                    {
                        System.Diagnostics.Debug.WriteLine("DeleteService failed");
                        CloseServiceHandle(sc_hndl);
                        return false;
                    }
                }
                else
                {
                    System.Diagnostics.Debug.WriteLine("OpenService failed");
                    return false;
                }
            }
            else
            {
                System.Diagnostics.Debug.WriteLine("OpenSCManager failed");
                return false;
            }
        }
    }

}