using System;
using System.Collections.Generic;
using System.Text;

namespace TFTPUtil
{
    class TFTPServerProcessContainer
    {
        public TFTPServerProcess _process = null;
        public System.Threading.Thread thread = null;
        public System.Threading.ThreadStart threadStart = null;

        public TFTPServerProcessContainer(TFTPServerProcess process)
        {
            this.process = process;
            this.threadStart = new System.Threading.ThreadStart(this.process.StartListener);
            this.thread = new System.Threading.Thread(this.threadStart);
            this.thread.Name = "TFTP Server Process Thread: " + this.process.ident.ToString();
            this.thread.IsBackground = true;
            this.thread.Start();
        }

        public TFTPServerProcess process
        {
            get
            {
                return _process;
            }
            set
            {
                _process = value;
            }
        }
    }
}
