using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Net;
using System.Windows.Forms;
using Microsoft.Win32;
using tftpUtilSvc;

namespace tftpUtilSvcSettings
{
    /// <summary>
    /// The frmOptions class is used to create windows form that allows users to configure options within the TFTP server
    /// </summary>
    partial class frmOptions : Form
    {
        private RegistryKey regkey;
        private string keypath=".DEFAULT\\Software\\tftpUtilSvc";
        private tftpUtilSvcSettings.ServerSettings _ServerSettings;
        /// <summary>
        /// This form allows the user to configure options within the TFTP Server and GUI
        /// </summary>
        /// <param name="srv">A reference to the current TFTPServer instance</param>
        /// <param name="ShowAlert">Determins the begining state of the Show Alert checkbox</param>
        /// <param name="FadeAlert">Indicates if should fade out the transfer alert window</param>
        /// <param name="keypath">A string representing the location of the registry keys</param>
        /// <param name="CloseAlert">Indicates if we should close the alert window when the transfer is finished</param>
        /// <param name="TransparentAlert">Indicates if the alert window should be transparent</param>
        public frmOptions()
        {
            InitializeComponent();
            regkey = Registry.Users.OpenSubKey(keypath, true);
            _ServerSettings = new tftpUtilSvcSettings.ServerSettings();
            string BlockedIPs = _ServerSettings.BlockedIPs;
            foreach (string IP in BlockedIPs.Split(';'))
            {
                System.Net.IPAddress tempaddr;
                if (System.Net.IPAddress.TryParse(IP, out tempaddr))
                    lstIPs.Items.Add(IP);
            }
            //========
            string svcPath = tftpUtilSvcConsts.getServicePath();
            updateServiceStatus();
        }
        private enum theServiceStatus
        {
            notInstalled,
            stopped,
            running
        }
        private theServiceStatus myServiceStat;
        private void updateServiceStatus(){
            if (myServiceControl.IsServiceInstalled(tftpUtilSvcConsts.serviceName))
            {
                if (myServiceControl.IsServiceRunning(tftpUtilSvcConsts.serviceName))
                {
                    lblServiceStatus.Text = "Service up and running";
                    pictureBox1.BackColor = Color.Green;
                    btnStartStop.Text = "Stop";
                    myServiceStat = theServiceStatus.running;
                    mnuStart.Enabled = false;
                    mnuStop.Enabled = true;
                    mnuInstall.Enabled = false;
                    mnuRestart.Enabled = true;
                    mnuUninstall.Enabled = false;
                }
                else
                {
                    lblServiceStatus.Text = "Service is not running";
                    pictureBox1.BackColor = Color.Yellow;
                    myServiceStat = theServiceStatus.stopped;
                    btnStartStop.Text = "Start";
                    mnuStart.Enabled = true;
                    mnuStop.Enabled = false;
                    mnuInstall.Enabled = false;
                    mnuRestart.Enabled = false;
                    mnuUninstall.Enabled = true;
                }
            }
            else
            {
                lblServiceStatus.Text = "Service " + tftpUtilSvcConsts.serviceName + " is not installed";
                pictureBox1.BackColor = Color.Red;
                myServiceStat = theServiceStatus.notInstalled;
                btnStartStop.Text = "Install";
                mnuStart.Enabled = false;
                mnuStop.Enabled = false;
                mnuInstall.Enabled = true;
                mnuRestart.Enabled = false;
                mnuUninstall.Enabled = false;
            }
        }
        private void btnBrowse_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = txtPath.Text;
            DialogResult result = folderBrowserDialog1.ShowDialog(this);
            if (result == DialogResult.OK)
                txtPath.Text = folderBrowserDialog1.SelectedPath;
        }

        private void frmOptions_Load(object sender, EventArgs e)
        {
            txtPath.Text = _ServerSettings.sPath;// server.Path;
            tftpUtilSvcSettings.ServerSettings server = _ServerSettings;
            if (cboLoggingLevel.Items.IndexOf(_ServerSettings.LoggingLevel) > -1)
                cboLoggingLevel.SelectedIndex = cboLoggingLevel.Items.IndexOf(_ServerSettings.LoggingLevel);

            if (cboDisplayLevel.Items.IndexOf(_ServerSettings.SendEventLevel) > -1)
                cboDisplayLevel.SelectedIndex = cboDisplayLevel.Items.IndexOf(_ServerSettings.SendEventLevel);

            if (!server.AllowRRQ && !server.AllowWRQ && !server.AllowWRQOverwrite)
            {
                if (cboFileAccess.Items.IndexOf("No Access") > -1)
                    cboFileAccess.SelectedIndex = cboFileAccess.Items.IndexOf("No Access");
            }
            else if (server.AllowRRQ && !server.AllowWRQ && !server.AllowWRQOverwrite)
            {
                if (cboFileAccess.Items.IndexOf("Read Only") > -1)
                    cboFileAccess.SelectedIndex = cboFileAccess.Items.IndexOf("Read Only");
            }
            else if (!server.AllowRRQ && server.AllowWRQ && !server.AllowWRQOverwrite)
            {
                if (cboFileAccess.Items.IndexOf("Write") > -1)
                    cboFileAccess.SelectedIndex = cboFileAccess.Items.IndexOf("Write");
            }
            else if (server.AllowRRQ && server.AllowWRQ && !server.AllowWRQOverwrite)
            {
                if (cboFileAccess.Items.IndexOf("Read and Write") > -1)
                    cboFileAccess.SelectedIndex = cboFileAccess.Items.IndexOf("Read and Write");
            }
            else if (server.AllowRRQ && server.AllowWRQ && server.AllowWRQOverwrite)
            {
                if (cboFileAccess.Items.IndexOf("Read and Overwrite") > -1)
                    cboFileAccess.SelectedIndex = cboFileAccess.Items.IndexOf("Read and Overwrite");
            }

            IPHostEntry localMachineInfo = Dns.GetHostEntry(Dns.GetHostName());
            foreach (IPAddress addr in localMachineInfo.AddressList)
            {
                if (addr.AddressFamily == System.Net.Sockets.AddressFamily.InterNetwork)
                {
                    cboInterface.Items.Add(addr.ToString());
                }
            }

            if (server.ServerIPAddr == "0.0.0.0")
                    cboInterface.SelectedIndex = 0;
            else if (cboInterface.Items.IndexOf(server.ServerIPAddr) > -1)
                cboInterface.SelectedIndex = cboInterface.Items.IndexOf(server.ServerIPAddr);

            txtPort.Text = server.ListenerPortNumber.ToString();

            txtResend.Text = server.ResendIntervalSeconds.ToString();

            txtTimeout.Text = server.TimeoutSeconds.ToString();

            chkRRQWRQCheck.Checked = server.RRQWRQStateCheck;

            chkTFTPOptions.Checked = server.AllowOptions;

            string MethodName = "";

            switch (server.LoggingMethod)
            {
                case "NSpring.Logging.Loggers.WindowsEventLogger":
                    MethodName = "Windows Event";
                    break;
                case "NSpring.Logging.Loggers.FileLogger":
                    MethodName = "Text File";
                    break;
                case "NSpring.Logging.Loggers.StreamLogger":
                    MethodName = "XML File";
                    break;
                case "NSpring.Logging.Loggers.DatabaseLogger":
                    MethodName = "SQL";
                    break;
                case "NSpring.Logging.Loggers.EmailLogger":
                    MethodName = "Email";
                    break;
            }

            if (cboLoggingMethod.Items.IndexOf(MethodName) > -1)
                cboLoggingMethod.SelectedIndex = cboLoggingMethod.Items.IndexOf(MethodName);

            txtChangeMethod.Text = server.LoggingOptions;

            string ClientPath = Application.StartupPath + "\\" + "TFTPUtil Client GUI.exe";
            if (regkey != null)
            {
                if (regkey.GetValue("TFTPClientPath") != null)
                    ClientPath = regkey.GetValue("TFTPClientPath").ToString();
            }

            txtClientPath.Text = ClientPath;
        }

        private void txtResend_Leave(object sender, EventArgs e)
        {
            try
            {
                if ((Convert.ToInt32(txtResend.Text) < 1) && (Convert.ToInt32(txtResend.Text) > 255))
                {
                    MessageBox.Show("Number of Seconds before Resending Last Packet must be an integer between 1 and 255 Seconds");
                    txtResend.Text = "1";
                }
            }
            catch (Exception)
            {
                MessageBox.Show("Number of Seconds before Resending Last Packet must be an integer between 1 and 255 Seconds");
                txtResend.Text = "1";
            }
        }

        private void txtTimeout_Leave(object sender, EventArgs e)
        {
            try
            {
                if ((Convert.ToInt32(txtTimeout.Text) < 1) && (Convert.ToInt32(txtTimeout.Text) > 255))
                {
                    MessageBox.Show("Timeout Interval in Seconds must be an integer between 1 and 255 Seconds");
                    txtTimeout.Text = "10";
                }
            }
            catch (Exception)
            {
                MessageBox.Show("Timeout Interval in Seconds must be an integer between 1 and 255 Seconds");
                txtTimeout.Text = "10";
            }
        }

        private void cboLoggingMethod_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (cboLoggingMethod.Items[cboLoggingMethod.SelectedIndex].ToString().ToLower())
            {
                case "windows event":
                    lblChangeMethod.Text = "Events Log Name:";
                    lblChangeMethod.Visible = true;
                    txtChangeMethod.Visible = true;
                    btnMethodPath.Visible = false;
                    picInfo.Visible = false;
                    break;
                case "sql":
                    lblChangeMethod.Text = "Connection String:";
                    lblChangeMethod.Visible = true;
                    txtChangeMethod.Visible = true;
                    btnMethodPath.Visible = false;
                    picInfo.Visible = true;
                    EventToolTip.ToolTipTitle = "SQL Connection String Example:";
                    EventToolTip.SetToolTip(picInfo, "Server=GOOEYTOP\\SQLEXPRESS;Database=TFTPUtil;User ID=testuser;Password=testpassword;Connection Timeout=5");
                    break;
                case "text file":
                    lblChangeMethod.Text = "Text File Path:";
                    lblChangeMethod.Visible = true;
                    txtChangeMethod.Visible = true;
                    btnMethodPath.Visible = true;
                    picInfo.Visible = false;
                    break;
                case "xml file":
                    lblChangeMethod.Text = "XML File Path:";
                    lblChangeMethod.Visible = true;
                    txtChangeMethod.Visible = true;
                    btnMethodPath.Visible = true;
                    picInfo.Visible = false;
                    break;
                case "email":
                    lblChangeMethod.Text = "Email Settings:";
                    lblChangeMethod.Visible = true;
                    txtChangeMethod.Visible = true;
                    btnMethodPath.Visible = false;
                    picInfo.Visible = true;
                    EventToolTip.ToolTipTitle = "Email Logging Example:";
                    EventToolTip.SetToolTip(picInfo, "mail.server.com,from@emailaddress.com,to@emailaddress.com");
                    break;
                default:
                    lblChangeMethod.Visible = false;
                    txtChangeMethod.Visible = false;
                    btnMethodPath.Visible = false;
                    picInfo.Visible = false;
                    break;
            }
        }

        private void btnMethodPath_Click(object sender, EventArgs e)
        {
            saveFileDialog1.InitialDirectory = txtPath.Text;

            DialogResult result = saveFileDialog1.ShowDialog(this);
            if (result == DialogResult.OK)
                txtChangeMethod.Text = saveFileDialog1.FileName;
        }

        private void btnClientPath_Click(object sender, EventArgs e)
        {
            saveFileDialog1.InitialDirectory = txtClientPath.Text;

            DialogResult result = saveFileDialog1.ShowDialog(this);
            if (result == DialogResult.OK)
                txtClientPath.Text = saveFileDialog1.FileName;
        }

        private void pic_Click(object sender, EventArgs e)
        {
            picGeneral.BorderStyle = BorderStyle.None;
            picSecurity.BorderStyle = BorderStyle.None;
            picServer.BorderStyle = BorderStyle.None;
            picAlert.BorderStyle = BorderStyle.None;
            ((PictureBox)sender).BorderStyle = BorderStyle.FixedSingle;

            pnlAlert.Visible = false;
            pnlGeneral.Visible = false;
            pnlServer.Visible = false;
            pnlSecurity.Visible = false;

            if (sender.Equals(picServer))
            {
                pnlServer.Visible = true;
            }
            else if (sender.Equals(picSecurity))
            {
                pnlSecurity.Visible = true;
            }
            else if (sender.Equals(picAlert))
            {
                pnlAlert.Visible = true;
            }
            else
            {
                //Always make sure something is visible
                pnlGeneral.Visible = true;
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            System.Net.IPAddress newaddr;
            bool ValidIP = System.Net.IPAddress.TryParse(txtAddress.Text, out newaddr);
            if (ValidIP)
                lstIPs.Items.Add(txtAddress.Text);
            else
                MessageBox.Show(txtAddress.Text + " is an invalid IP address.");
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            if (lstIPs.SelectedIndex > -1)
                lstIPs.Items.RemoveAt(lstIPs.SelectedIndex);
            else
                MessageBox.Show("Please select an IP address to remove");
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            SaveSettings();
            this.Close();
            Application.Exit();
        }
        private void SaveSettings()
        {
            tftpUtilSvcSettings.ServerSettings tftp = _ServerSettings;
            if (regkey == null)
            {
                regkey = Registry.Users.CreateSubKey(keypath);
            }
            //RegistryKey regkey=Registry.Users.OpenSubKey(regs
            switch (this.cboFileAccess.Items[this.cboFileAccess.SelectedIndex].ToString())
            {
                case "No Access":
                    //if (regkey != null)
                    //    regkey.SetValue("FileAccess", "No Access");
                    tftp.FileAccess = "No Access";
                    tftp.AllowRRQ = false;
                    tftp.AllowWRQ = false;
                    tftp.AllowWRQOverwrite = false;
                    break;
                case "Read Only":
                    //if (regkey != null)
                    //    regkey.SetValue("FileAccess", "Read Only");
                    tftp.FileAccess = "Read Only";
                    tftp.AllowRRQ = true;
                    tftp.AllowWRQ = false;
                    tftp.AllowWRQOverwrite = false;
                    break;
                case "Write":
                    //if (regkey != null)
                    //    regkey.SetValue("FileAccess", "Write");
                    tftp.FileAccess = "Write";
                    tftp.AllowRRQ = false;
                    tftp.AllowWRQ = true;
                    tftp.AllowWRQOverwrite = false;
                    break;
                case "Read and Write":
                    //if (regkey != null)
                    //    regkey.SetValue("FileAccess", "Read and Write");
                    tftp.FileAccess = "Read and Write";
                    tftp.AllowRRQ = true;
                    tftp.AllowWRQ = true;
                    tftp.AllowWRQOverwrite = false;
                    break;
                case "Read and Overwrite":
                    //if (regkey != null)
                    //    regkey.SetValue("FileAccess", "Read and Overwrite");
                    tftp.FileAccess = "Read and Overwrite";
                    tftp.AllowRRQ = true;
                    tftp.AllowWRQ = true;
                    tftp.AllowWRQOverwrite = true;
                    break;
            }

            tftp.SendEventLevel = cboDisplayLevel.Items[this.cboDisplayLevel.SelectedIndex].ToString();
            //if (regkey != null)
            //    regkey.SetValue("DisplayLevel", this.cboDisplayLevel.Items[this.cboDisplayLevel.SelectedIndex].ToString());

            tftp.LoggingLevel = this.cboLoggingLevel.Items[this.cboLoggingLevel.SelectedIndex].ToString();
            //if (regkey != null)
            //    regkey.SetValue("LoggingLevel", this.cboLoggingLevel.Items[this.cboLoggingLevel.SelectedIndex].ToString());

            tftp.sPath = this.txtPath.Text;
            //if (regkey != null)
            //    regkey.SetValue("Path", this.txtPath.Text);

            tftp.AllowOptions = this.chkTFTPOptions.Checked;
            //if (regkey != null)
            //    regkey.SetValue("AllowOptions", this.chkTFTPOptions.Checked.ToString());

            tftp.RRQWRQStateCheck = this.chkRRQWRQCheck.Checked;
            //if (regkey != null)
            //    regkey.SetValue("RRQWRQStateCheck", this.chkRRQWRQCheck.Checked.ToString());

            bool SetPort = false;

            if (this.cboInterface.SelectedItem != null)
            {
                string OptionsIP = this.cboInterface.SelectedItem.ToString();
                if (OptionsIP == "any")
                    OptionsIP = "0.0.0.0";

                if ((tftp.ServerIPAddr != OptionsIP) ||
                    (tftp.ServerUDPPort != this.txtPort.Text))
                {
                    if (regkey != null)
                        regkey.SetValue("ServerUDPPort", this.txtPort.Text);
                    if (regkey != null)
                        regkey.SetValue("ServerIPAddr", this.cboInterface.SelectedItem.ToString());

                    if (this.cboInterface.SelectedItem.ToString().ToLower() == "any")
                    {
                        tftp.ListenerIPAddresses = new System.Net.IPAddress[] { System.Net.IPAddress.Any };
                    }
                    else
                    {
                        tftp.ListenerIPAddresses = new System.Net.IPAddress[] { System.Net.IPAddress.Parse(this.cboInterface.SelectedItem.ToString()) };
                        if (tftp.ListenerPortNumber.ToString() != this.txtPort.Text)
                        {
                            SetPort = true;
                            tftp.ListenerPortNumber = Convert.ToInt32(this.txtPort.Text);
                        }
                    }
                }
            }

            if ((tftp.ListenerPortNumber.ToString() != this.txtPort.Text) && !SetPort)
            {
                tftp.ServerUDPPort = this.txtPort.Text;
                //if (regkey != null)
                //    regkey.SetValue("ServerUDPPort", this.txtPort.Text);
                tftp.ListenerPortNumber = Convert.ToInt32(this.txtPort.Text);
            }

            tftp.ResendIntervalSeconds = Convert.ToInt32(this.txtResend.Text);
            tftp.Resend = this.txtResend.Text;

            //if (regkey != null)
            //    regkey.SetValue("Resend", this.txtResend.Text);

            tftp.TimeoutSeconds = Convert.ToInt32(this.txtTimeout.Text);
            tftp.Timeout = this.txtTimeout.Text;

            //if (regkey != null)
            //    regkey.SetValue("Timeout", this.txtTimeout.Text);

            if (this.cboLoggingMethod.SelectedIndex > -1)
            {
                tftp.LoggingMethod = this.cboLoggingMethod.Items[this.cboLoggingMethod.SelectedIndex].ToString();
                // new string[] { this.cboLoggingMethod.Items[this.cboLoggingMethod.SelectedIndex].ToString(), this.txtChangeMethod.Text };
                //if (regkey != null)
                //    regkey.SetValue("LoggingMethod", tftp.LoggingMethod);//this.cboLoggingMethod.Items[this.cboLoggingMethod.SelectedIndex].ToString());
            }

            //if (regkey != null)
            //    regkey.SetValue("LoggingOptions", this.txtChangeMethod.Text);
            tftp.LoggingOptions = this.txtChangeMethod.Text;

            string badips = "";
            for (int i = 0; i < this.lstIPs.Items.Count; i++)
            {
                badips += this.lstIPs.Items[i].ToString();
                if (i != (this.lstIPs.Items.Count - 1))
                    badips += ";";
            }

            //if (regkey != null)
            //    regkey.SetValue("BlockedIPs", badips);

            tftp.BlockedIPs = badips;
            if (regkey != null)
                regkey.Close();
            MessageBox.Show("Settings saved. Restart service to apply");
        }
        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Dispose();
            Application.Exit();
        }
        private void svcInstall()
        {
            // D:\C-Source\test\tftpUtilSvc\bin\Debug\tftpUtilSvc.exe
            string svcPath = tftpUtilSvcConsts.getServicePath();
            if (System.IO.File.Exists(svcPath))
                myServiceInstaller.InstallService(svcPath, tftpUtilSvcConsts.serviceName, tftpUtilSvcConsts.serviceDisplayName);
            else
            {
                OpenFileDialog ofd = new OpenFileDialog();
                ofd.CheckFileExists = true;
                ofd.CheckPathExists = true;
                ofd.InitialDirectory = System.IO.Path.GetDirectoryName(svcPath);
                ofd.Filter = "tftpUtilSvc|tftpUtilSvc.exe|All files (*.*)|*.*";
                ofd.FilterIndex = 0;
                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    svcPath = ofd.FileName;
                    ofd.Dispose();
                    if (myServiceInstaller.InstallService(svcPath, tftpUtilSvcConsts.serviceName, tftpUtilSvcConsts.serviceDisplayName))
                    {
                        myServiceStat = theServiceStatus.stopped;
                    }
                }
            }
        }
        private void svcUninstall()
        {
            myServiceControl.StopService(tftpUtilSvcConsts.serviceName, 10000);
            if (myServiceInstaller.UnInstallService(tftpUtilSvcConsts.serviceName))
                MessageBox.Show("Service uninstalled");
            else
                MessageBox.Show("Service uninstall FAILED");
            updateServiceStatus();
        }
        //private bool bStarted = false;
        //private tftpUtilSvc.tftpUtilSvc _tftpUtilSvc;
        private void btnStartStop_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            switch (myServiceStat)
            {
                case theServiceStatus.notInstalled:
                    svcInstall();
                    break;
                case theServiceStatus.running:
                    myServiceControl.StopService(tftpUtilSvcConsts.serviceName, 10000);
                    break;
                case theServiceStatus.stopped:
                    myServiceControl.StartService(tftpUtilSvcConsts.serviceName, 10000);
                    break;
            }
            updateServiceStatus();
            Cursor.Current = Cursors.Default;
        }

        private void mnuSave_Click(object sender, EventArgs e)
        {
            SaveSettings();
        }

        private void mnuUninstall_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            svcUninstall();
            updateServiceStatus();
            Cursor.Current = Cursors.Default;
        }

        private void mnuStart_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            myServiceControl.StartService(tftpUtilSvcConsts.serviceName, 10000);
            updateServiceStatus();
            Cursor.Current = Cursors.Default;
        }

        private void mnuStop_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            myServiceControl.StopService(tftpUtilSvcConsts.serviceName, 10000);
            updateServiceStatus();
            Cursor.Current = Cursors.Default;
        }

        private void mnuInstall_Click(object sender, EventArgs e)
        {
            svcInstall();
            updateServiceStatus();
        }

        private void mnuExit_Click(object sender, EventArgs e)
        {
            this.Close();
            Application.Exit();
        }
    }
}