using System;
using System.Collections.Generic;
using System.Text;
using NSpring.Logging;

namespace TFTPUtil
{
    /// <summary>
    /// A delegate for the TFTP server event handler
    /// </summary>
    /// <param name="sender">An object representing the sender of the event</param>
    /// <param name="e">The event arguments</param>
    public delegate void TFTPServerProcessEventHandler(object sender, TFTPServerProcessEventArgs e);

    /// <summary>
    /// A class specifying the arguments for the TFTP server event
    /// </summary>
    public class TFTPServerProcessEventArgs : EventArgs
    {
        private string DisplayString;
        private Level EventDisplayLevel;

        /// <summary>
        /// A class that defines the TFTP server event arguments
        /// </summary>
        /// <param name="EventString">The event message to display</param>
        public TFTPServerProcessEventArgs(string EventString, Level EventLevel)
        {
            this.DisplayString = EventString;
            this.EventDisplayLevel = EventLevel;
        }

        /// <summary>
        /// Gets the event message to display
        /// </summary>
        public string EventString
        {
            get
            {
                return DisplayString;
            }
        }

        /// <summary>
        /// Gets the event level
        /// </summary>
        public Level EventLevel
        {
            get
            {
                return EventDisplayLevel;
            }
        }
    }
}
