using System;
using System.Text;

namespace TFTPUtil
{
    /// <summary>
    /// This class keeps state information about on going TFTP transfer for use in a user interface
    /// </summary>
    public class TFTPTransferState
    {
        public readonly Guid ident = Guid.NewGuid();
        private int Opcode;
        /// <summary>
        /// A long specifying the length of the file
        /// </summary>
        public long FileLength = 0;
        /// <summary>
        /// A long specifying the current number of bytes transfered
        /// </summary>
        public long BytesTransfered = 0;
        /// <summary>
        /// If the TFTP transfer is currently open
        /// </summary>
        public bool Opened = true;
        /// <summary>
        /// If the TFTP transfer is currently closed
        /// </summary>
        public bool Closed = false;
        private string RemoteAddress;
        private int Port;
        private string FileName;
        public bool ErrorOccurred = false;
        public string ErrorMsg = "";

        /// <summary>
        /// Creates a new instance of the TFTPTransferState
        /// </summary>
        /// <param name="Opcode">The original TFTP Opcode received from the remote</param>
        /// <param name="RemoteIPAddress">The Remote IP Address initiating the transfer</param>
        /// <param name="Port">The remote UDP port</param>
        /// <param name="FileName">The file name the remote client connected</param>
        public TFTPTransferState(int Opcode, string RemoteIPAddress, int Port, string FileName)
        {
            this.Opcode = Opcode;
            RemoteAddress = RemoteIPAddress;
            this.Port = Port;
            this.FileName = FileName;
        }

        /// <summary>
        /// Returns the original TFTP message type received from the remote
        /// </summary>
        public int TransferType
        {
            get
            {
                return Opcode;
            }
        }

        /// <summary>
        /// Gets the Remote IP Address
        /// </summary>
        public string RemoteIPAddress
        {
            get
            {
                return RemoteAddress;
            }
        }

        /// <summary>
        /// Gets the remote UDP port
        /// </summary>
        public int RemotePort
        {
            get
            {
                return Port;
            }
        }

        /// <summary>
        /// Gets the filename the remore client specified
        /// </summary>
        public string Filename
        {
            get
            {
                return FileName;
            }
        }
    }
}
