﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Win32;

namespace tftpUtilSvcSettings
{
    public class ServerSettings
    {
        private const string regSubKey = ".Default\\Software\\tftpUtilSvc";
        private string _blockedIPs;
        private string _sPath;
        private string _LoggingLevel;
        private string _SendEventLevel;
        private bool _AllowRRQ;
        private bool _AllowWRQ;
        private bool _AllowWRQOverwrite;
        private System.Net.IPAddress[] _ListenerIPAddresses;
        
        private string _ServerIPAddr;
        private string _ServerUDPPort;

        private int _ListenerPortNumber;
        private int _ResendIntervalSeconds;
        private int _TimeoutSeconds;
        private bool _RRQWRQStateCheck;
        private bool _AllowOptions;
        private string _LoggingMethod;
        private string _FileAccess;
        private string _LoggingOptions;
        private string _Resend;
        private string _Timeout;

        public ServerSettings()
        {
            //defaults
            _blockedIPs="";
            _sPath="c:\\";
            _LoggingLevel="";
            _SendEventLevel="";
            _AllowRRQ=true;
            _AllowWRQ = true;
            _AllowWRQOverwrite = true;
            
            _Resend = _ResendIntervalSeconds.ToString();
    
            _ServerIPAddr = "127.0.0.1";
            _ServerUDPPort = "69";

            _ListenerIPAddresses = new System.Net.IPAddress[] { System.Net.IPAddress.Parse("127.0.0.1") };
            _ListenerPortNumber=69;
            _ResendIntervalSeconds=1;
            _TimeoutSeconds=10;
            _Timeout = "10";
            _RRQWRQStateCheck=true;
            _AllowOptions=true;
            _LoggingMethod = "NSpring.Logging.Loggers.WindowsEventLogger"; // new string[] { "NSpring.Logging.Loggers.WindowsEventLogger" };

            _FileAccess = "Read and Overwrite";

            _LoggingOptions = "tftpuTilSvC";
            if (isRegInitialized())
            {
                _blockedIPs = BlockedIPs;
                _sPath = sPath;
                _LoggingLevel = LoggingLevel;
                _SendEventLevel = SendEventLevel;
                _AllowRRQ = AllowRRQ;
                _AllowWRQ = AllowWRQ;
                _AllowWRQOverwrite = AllowWRQOverwrite;
                _ListenerIPAddresses = ListenerIPAddresses;
                _ListenerPortNumber = ListenerPortNumber;
                _ResendIntervalSeconds = ResendIntervalSeconds;
                _TimeoutSeconds = TimeoutSeconds;
                _Timeout = Timeout;
                _RRQWRQStateCheck = RRQWRQStateCheck;
                _AllowOptions = AllowOptions;
                _LoggingMethod = LoggingMethod;
                _LoggingOptions = LoggingOptions; 

                _ServerIPAddr = ServerIPAddr;
                _ServerUDPPort = ServerUDPPort;

                _FileAccess = FileAccess;
                _Resend = Resend;
            }
            else
            {
                //create the regkey
                RegistryKey rk = Registry.Users.CreateSubKey(regSubKey, RegistryKeyPermissionCheck.ReadWriteSubTree);
                rk.Close();
                //save defaults
                BlockedIPs = _blockedIPs;
                sPath = _sPath;
                LoggingLevel = _LoggingLevel;
                SendEventLevel = _SendEventLevel; //this is DisplayLevel
                AllowRRQ = _AllowRRQ;
                AllowWRQ = _AllowWRQ;
                AllowWRQOverwrite = _AllowWRQOverwrite;
                ListenerIPAddresses = _ListenerIPAddresses;
                ListenerPortNumber = _ListenerPortNumber;
                ResendIntervalSeconds = _ResendIntervalSeconds;
                TimeoutSeconds = _TimeoutSeconds;
                Timeout = _Timeout;
                RRQWRQStateCheck = _RRQWRQStateCheck;
                AllowOptions = _AllowOptions;
                LoggingMethod = _LoggingMethod;

                ServerIPAddr = _ServerIPAddr;
                ServerUDPPort = _ServerUDPPort;

                FileAccess = _FileAccess;
                Resend = _Resend;
            }
        }
        public string Timeout
        {
            get { return regGetString("Timeout"); }
            set { regSetString("Timeout", value); }
        }
        public string Resend
        {
            get { return regGetString("Resend"); }
            set { regSetString("Resend", value); }
        }
        public string LoggingOptions
        {
            get { return regGetString("LoggingOptions"); }
            set { regSetString("LoggingOptions", value); }
        }
        public string FileAccess
        {
            get { return regGetString("FileAccess"); }
            set { regSetString("FileAccess", value); }
        }
        public string BlockedIPs
        {
            get { return regGetString("blockedIPs"); }
            set { regSetString("blockedIPs", value);}
        }
        public string sPath
        {
            get { return regGetString("path"); }
            set { regSetString("path", value);}
        }
        public string LoggingLevel
        {
            get { return regGetString("LoggingLevel"); }
            set { regSetString("LoggingLevel", value); }
        }
        public string SendEventLevel
        {
            get { return regGetString("DisplayLevel"); }
            set { regSetString("DisplayLevel", value); }
        }
        public bool AllowRRQ
        {
            get {
                if (regGetDword("AllowRRQ") == 1)
                    return true;
                else
                    return false;
            }
            set { 
                if(value)
                    regSetDword("AllowRRQ", 1);
                else
                    regSetDword("AllowRRQ", 0);
            }
        }
        public bool AllowWRQ
        {
            get {
                if (regGetDword("AllowWRQ") == 1)
                    return true;
                else
                    return false;
            }
            set { 
                if(value)
                    regSetDword("AllowWRQ", 1);
                else
                    regSetDword("AllowWRQ", 0);
            }
        }
        public bool AllowWRQOverwrite
        {
            get {
                if (regGetDword("AllowWRQOverwrite") == 1)
                    return true;
                else
                    return false;
            }
            set { 
                if(value)
                    regSetDword("AllowWRQOverwrite", 1);
                else
                    regSetDword("AllowWRQOverwrite", 0);
            }
        }
        public System.Net.IPAddress[] ListenerIPAddresses
        {
            get {
                return _getListenerIpAdresses();
            }
            set {
                _setListenerIpAdresses(value);
            }
        }
        public string ServerIPAddr
        {
            get { return regGetString("ServerIPAddr"); }
            set { regSetString("ServerIPAddr", value); }

        }
        public string ServerUDPPort
        {
            get { return regGetString("ServerUDPPort"); }
            set { regSetString("ServerUDPPort", value); }

        }
        public int ListenerPortNumber
        {
            get { return regGetDword("ListenerPortNumber"); }
            set { regSetDword("ListenerPortNumber", value); }
        }
        public int ResendIntervalSeconds
        {
            get { return regGetDword("ResendIntervalSeconds"); }
            set { regSetDword("ResendIntervalSeconds", value); }
        }
        public int TimeoutSeconds
        {
            get { return regGetDword("TimeoutSeconds"); }
            set { regSetDword("TimeoutSeconds", value); }
        }
        public bool RRQWRQStateCheck
        {
            get
            {
                if (regGetString("RRQWRQStateCheck") == "True")
                    return true;
                else
                    return false;
            }
            set
            {
                if (value)
                    regSetString("RRQWRQStateCheck", "True");
                else
                    regSetString("RRQWRQStateCheck", "False");
            }
        }
        public bool AllowOptions
        {
            get
            {
                if (regGetString("AllowOptions") == "True")
                    return true;
                else
                    return false;
            }
            set
            {
                if (value)
                    regSetString("AllowOptions", "True");
                else
                    regSetString("AllowOptions", "False");
            }
        }
        public string LoggingMethod
        {
            get {
                return regGetString("LoggingMethod");
            }
            set {
                string MethodName;
                switch (value)
                {
                    case "Windows Event":
                        MethodName = "NSpring.Logging.Loggers.WindowsEventLogger";
                        break;
                    case "Text File":
                        MethodName = "NSpring.Logging.Loggers.FileLogger";
                        break;
                    case "XML File":
                        MethodName = "NSpring.Logging.Loggers.StreamLogger";
                        break;
                    case "SQL":
                        MethodName = "NSpring.Logging.Loggers.DatabaseLogger";
                        break;
                    case "Email":
                        MethodName = "NSpring.Logging.Loggers.EmailLogger";
                        break;
                    default:
                        MethodName = "NSpring.Logging.Loggers.WindowsEventLogger";
                        break;
                }

                regSetString("LoggingMethod",MethodName);
            }
        }
        //private string[] _LoggingMethod = new string[] { "", "" };
        private string[] _getLoggingMethod()
        {
            string[] sL=regGetMultiString("LoggingMethod");
            if (sL == null || sL.Length != 2)
            {
                string[] _sL;
                _sL = new string[2];
                _sL[0] = "";
                _sL[1] = "";
                return _sL;
            }
            else
                return sL;
        }
        private bool _setLoggingMethod(string[] _sStr)
        {
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            try
            {
                rk.SetValue("LoggingMethod", _sStr, RegistryValueKind.MultiString);
                rk.Close();
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }
        private bool _setListenerIpAdresses(System.Net.IPAddress[] _IPs)
        {
            string[] _sIPs;
            _sIPs = new string[_IPs.Length];
            for (int i = 0; i < _IPs.Length; i++)
            {
                _sIPs[i] = _IPs[i].ToString();
            }
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            try
            {
                rk.SetValue("ListenerIpAdresses", _sIPs, RegistryValueKind.MultiString);
                return true;
            }
            catch (Exception)
            {
                return false;                    
            }
        }
        private string[] regGetMultiString(string sRegKey)
        {
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            object o;
            string[] sRet={""};
            try
            {
                o=rk.GetValue(sRegKey);
                if (o != null)
                    sRet = (string[])o;
                rk.Close();
                return sRet;
            }
            catch (Exception)
            {
                sRet = new string[]{""};
                return sRet;
            }
        }
        private System.Net.IPAddress[] _getListenerIpAdresses()
        {
            System.Net.IPAddress[] _IPs;
            try
            {
                string[] sIPs = regGetMultiString("ListenerIPAddresses");
                _IPs = new System.Net.IPAddress[sIPs.Length - 1];
                for (int i=0; i<sIPs.Length; i++)
                {
                    _IPs[i]=System.Net.IPAddress.Parse(sIPs[i]);
                }

            }
            catch (Exception)
            {
                _IPs=null;
                _IPs = new System.Net.IPAddress[1];
                _IPs[0] = System.Net.IPAddress.Parse("127.0.0.1");
            }
            return _IPs;
        }
        private Int32 regGetDword(string sRegKey)
        {
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            object o;
            Int32 iRet = 0;
            try
            {
                o = rk.GetValue(sRegKey);
                if (o != null)
                    iRet = (Int32)o;
                rk.Close();
                return iRet;
            }
            catch (Exception)
            {
                iRet = 0;
                return iRet;
            }
        }
        private string regGetString(string sRegKey)
        {
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            object o;
            string sRet="";
            try
            {
                o=rk.GetValue(sRegKey);
                if (o != null)
                    sRet = (string)o;
                rk.Close();
                return sRet;
            }
            catch (Exception)
            {
                sRet = "";
                return sRet;
            }
        }
        private bool regSetDword(string sRegKey, Int32 iValue)
        {
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            bool bRet = false;
            try
            {
                rk.SetValue(sRegKey, iValue, RegistryValueKind.DWord);
                //no exception
                bRet = true;
                rk.Close();
                return bRet;
            }
            catch (Exception)
            {
                bRet = false;
            }
            return bRet;
        }
        private bool regSetString(string sRegKey, string sValue)
        {
            RegistryKey rk = Registry.Users.OpenSubKey(regSubKey, true);
            bool bRet=false;
            try
            {
                rk.SetValue(sRegKey, sValue, RegistryValueKind.String);
                //no exception
                bRet = true;
                rk.Close();
                return bRet;
            }
            catch (Exception)
            {
                bRet = false;
            }
            return bRet;
        }
        private bool isRegInitialized()
        {
            RegistryKey rk;
            try 
	        {
                rk = Registry.Users.OpenSubKey(regSubKey,RegistryKeyPermissionCheck.ReadWriteSubTree);
                if (rk != null)
                {
                    rk.Close();
                    return true;
                }
                else
                    return false;
	        }
	        catch (Exception)
	        {
                return false;
	        } 
        }
        private void saveToReg()
        {
        }
    }
}
