﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Text;
using TFTPUtil;
using System.Threading;
using System.Collections;

using tftpUtilSvcSettings;

namespace tftpUtilSvc
{
    public partial class tftpUtilSvc1 : ServiceBase
    {
        private System.Threading.Timer CheckListeningTimer;
        private Thread TFTPServerThread;
        //private Thread AlertThread;

        private string BlockedIPs = "";

        private TFTPServer tftp;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="o"></param>
        /// <param name="e"></param>
        public delegate void TFTPServerHandler(object o, TFTPServerEventArgs e);
        private delegate void SetTextCallback(string text);
        private delegate void AddEventCallback(string text, Guid ident);
        private System.Windows.Forms.Timer timerEvents;
        private NSpring.Logging.Loggers.WindowsEventLogger eventLog;
        private ArrayList Processes = new ArrayList(5);
        private readonly object ProcessesLock = new object();
        private bool bCreateTFTPFromReg=false;
        private ServerSettings svcSettings;

        public tftpUtilSvc1()
        {
            InitializeComponent();
            //read settings from reg or defualt values
            svcSettings = new ServerSettings();
            //tftp = new TFTPServer(System.Net.IPAddress.Any);
            bCreateTFTPFromReg=CreateTFTPFromReg();
            eventLog = new NSpring.Logging.Loggers.WindowsEventLogger("tftpUtilSvc");
            //Start listening for events sent by the TFTPServer
            tftp.TFTPServerEvent += new TFTPServerEventHandler(this.TFTPEventListener);
            tftp.TFTPServerTransferEvent += new TFTPServerTransferEventHandler(this.TFTPServerListener);

            this.timerEvents = new System.Windows.Forms.Timer();
            this.timerEvents.Interval = 1000;
            this.timerEvents.Tick += new System.EventHandler(this.timerEvents_Tick);
        }
        public bool CreateTFTPFromReg()
        {
            AddLog("CreateTFTPFromReg entered...");
            bool returnval = false;
            System.Net.IPAddress ServerIPAddr = null;
            string Path = System.IO.Directory.GetCurrentDirectory();
            string LoggingLevel = "Info";
            string DisplayLevel = "Info";
            string FileAccess = "Read Only";
            int ServerUDPPort = 69;
            bool AllowOptions = true;
            bool RRQWRQStateCheck = true;
            int iTimeout = 10;
            int Resend = 1;
            string[] LoggingMethodInfo = { "Windows Event", System.Reflection.Assembly.GetExecutingAssembly().GetName().Name };

            try
            {
                AddLog("CreateTFTPFromReg reading path");
                Path = svcSettings.sPath;
                LoggingLevel = svcSettings.LoggingLevel;
                DisplayLevel = svcSettings.SendEventLevel;
                FileAccess = svcSettings.FileAccess;
                AllowOptions = svcSettings.AllowOptions;
                RRQWRQStateCheck = svcSettings.RRQWRQStateCheck;

                AddLog("CreateTFTPFromReg reading IPstring");
                string IPstring = svcSettings.ServerIPAddr;
                if (IPstring.ToLower() == "any")
                    ServerIPAddr = System.Net.IPAddress.Any;
                else
                    System.Net.IPAddress.TryParse(IPstring, out ServerIPAddr);

                AddLog("CreateTFTPFromReg reading ServerUDPPort");
                ServerUDPPort = Convert.ToInt32(svcSettings.ServerUDPPort);
                iTimeout = Convert.ToInt32(svcSettings.Timeout);
                Resend = Convert.ToInt32(svcSettings.Resend);

                AddLog("CreateTFTPFromReg reading LoggingMethodInfo");
                LoggingMethodInfo[0] = svcSettings.LoggingMethod;
                LoggingMethodInfo[1] = svcSettings.LoggingOptions;

                //bool ShowAlert = false;
                AddLog("CreateTFTPFromReg reading BlockedIPs");
                BlockedIPs = svcSettings.BlockedIPs;

                AddLog("CreateTFTPFromReg starting new TFTPServer(...)");
                if (ServerIPAddr == null)
                    tftp = new TFTPServer(ServerUDPPort, Path, LoggingLevel, DisplayLevel, FileAccess, AllowOptions, RRQWRQStateCheck, Resend, iTimeout, LoggingMethodInfo, BlockedIPs);
                else
                    tftp = new TFTPServer(ServerUDPPort, Path, LoggingLevel, DisplayLevel, FileAccess, AllowOptions, RRQWRQStateCheck, Resend, iTimeout, LoggingMethodInfo, BlockedIPs, ServerIPAddr);
                returnval = true;
                AddLog("CreateTFTPFromReg everything seems to be OK");
            }
            catch (Exception ex)
            {
                AddLog("CreateTFTPFromReg EXCEPTION:" + ex.Message);
            }
            return returnval;

        }
        private void AddLog(string s) {
            try
            {
                if (eventLog != null)
                    eventLog.Log(s);
                else
                {
                    eventLog = new NSpring.Logging.Loggers.WindowsEventLogger("tftpUtilSvc");
                    eventLog.Log(s);
                }
            }
            catch (Exception)
            {
            }
        }
        protected override void OnStart(string[] args)
        {
            AddLog("OnStart entered...");
            StartTFTPServer();
            Thread.Sleep(200);
            CheckListenState();

            CheckListeningTimer = new System.Threading.Timer(
                new TimerCallback(CheckListening), //Name of the method to call
                null,   // Don't send a state object
                1000,   // Start timer in 500ms
                2000);  // Do callback every 2 seconds

            timerEvents.Start();

        }

        public void _OnStart()
        {
            AddLog("OnStart entered...");
            StartTFTPServer();
            Thread.Sleep(200);
            CheckListenState();

            CheckListeningTimer = new System.Threading.Timer(
                new TimerCallback(CheckListening), //Name of the method to call
                null,   // Don't send a state object
                1000,   // Start timer in 500ms
                2000);  // Do callback every 2 seconds

            timerEvents.Start();

        }
        protected override void OnStop()
        {
            tftp.StopListener();
            if (TFTPServerThread != null)
                TFTPServerThread.Abort();
            TFTPServerThread = null;
            timerEvents.Stop();
            StopTFTPServer();
            GC.Collect();

        }
        public void _OnStop()
        {
            tftp.StopListener();
            if (TFTPServerThread != null)
                TFTPServerThread.Abort();
            TFTPServerThread = null;
            timerEvents.Stop();
            StopTFTPServer();
            GC.Collect();

        }

        private void StartTFTPServer()
        {
            try
            {
                AddLog("StartTFTPServer entered...");
                bool ls = tftp.IsListening;
                if(tftp==null)
                    CreateTFTPFromReg();
                //Starting the TFTP Listener thread
                TFTPServerThread = new Thread(new ThreadStart(tftp.StartListener));
                TFTPServerThread.Name = "TFTP Server Thread";
                TFTPServerThread.IsBackground = true;
                TFTPServerThread.Start();
                timerEvents.Start();
                AddLog("tftp server started");
            }
            catch (Exception ex)
            {
                AddLog(ex.Message);
            }
        }

        private void StopTFTPServer()
        {
            tftp.StopListener();
            if (TFTPServerThread != null)
                TFTPServerThread.Abort();
            TFTPServerThread = null;
            timerEvents.Stop();
            AddLog("tftp server stopped");
        }
        public void TFTPEventListener(object sender, TFTPServerEventArgs e)
        {
            object[] pList = { e.EventString };
            //BeginInvoke(new SetTextCallback(SetText), pList);
            AddLog(e.EventString);
        }
        public void TFTPServerListener(object sender, TFTPServerTransferEventArgs e)
        {
            object[] pList = { e.NewProcess };
            TFTPServerProcess Process = (TFTPServerProcess)pList[0];

            int Counter = 0;
            while (Counter <= 5)
            {
                if ((Process.CurrState != null) && Process.IsListening)
                {
                    //TFTPTransferState TransferState = ((TFTPState)Process.CurrStates[0]).TransferState;
                    TFTPTransferState TransferState = Process.CurrState.TransferState;

                    string EventText = "";
                    if (TransferState.TransferType == 1)
                        EventText = "Remote host " + TransferState.RemoteIPAddress + " is retrieving file " + TransferState.Filename;
                    else if (TransferState.TransferType == 2)
                        EventText = "Remote host " + TransferState.RemoteIPAddress + " is sending file " + TransferState.Filename;
                    AddEvent(EventText, Process.ident);

                    lock (ProcessesLock)
                    {
                        Processes.Add(Process);
                    }

                    Counter = 10;
                }
                System.Threading.Thread.Sleep(100);
                ++Counter;
            }

            UpdateActiveTransfers();
        }
        private void AddEvent(string text, Guid ident)
        {
            AddLog(text + ":" + ident.ToString());
        }
        private void UpdateActiveTransfers()
        {
            if (tftp.NumberSessions == 1)
                AddLog("1 Active Transfer");
            else
                AddLog(tftp.NumberSessions.ToString() + " Active Transfers");
        }
        private void CheckListening(object state)
        {
            if (tftp.IsListening)
            {
                AddLog("still listening...");
            }
            else
            {
                AddLog("NOT listening...");
            }

            UpdateActiveTransfers();
        }

        private void CheckListenState()
        {
            //This is a different check than the method CheckListening
            //This is used when someone manually starts and stops

            Thread.Sleep(50);  // Wait time in ms before checking incase we just started or stopped the thread

            if (tftp.IsListening)
            {
                foreach (System.Net.IPAddress addr in tftp.ListenerIPAddresses)
                {
                    if (addr.ToString().Length < 64)
                        AddLog("Listening to:" + addr.ToString());
                    if (addr == System.Net.IPAddress.Any)
                    {
                        AddLog("Listening to:" + "All IP Addresses");
                    }
                    else
                    {
                        AddLog("Listening to:" + addr.ToString());
                    }
                }

                AddLog("Listening port is:" + tftp.ListenerPortNumber.ToString());
            }
        }

        private void timerEvents_Tick(object sender, EventArgs e)
        {
            //try
            //{
            //ArrayList DeleteList = new ArrayList(5);

            //lock (ProcessesLock)
            //{
            //    for (int ProcessIndex = 0; ProcessIndex < Processes.Count; ++ProcessIndex)
            //    {
            //        TFTPServerProcess Process = (TFTPServerProcess)Processes[ProcessIndex];
                //    foreach (ListViewItem TempItem in lvEvents.Items)
                //    {
                //        if ((TempItem.Tag != null) && ((Guid)TempItem.Tag == Process.ident))
                //        {
                //            if (Process.CurrState != null)
                //            {
                //                TFTPTransferState TempState = Process.CurrState.TransferState;

                //                if ((Process.IsListening == false) && TempState.Opened)
                //                {
                //                    TempItem.Text = "Connection timed out for remote host " + TempState.RemoteIPAddress;
                //                    DeleteList.Add(ProcessIndex);
                //                }
                //                else
                //                {
                //                    if (TempState.Closed)
                //                    {
                //                        if (Process.CurrState.ErrorOccurred)
                //                        {
                //                            TempItem.Text = Process.CurrState.ErrorMsg;
                //                        }
                //                        else if ((TempState.TransferType == 1) && (TempState.BytesTransfered != TempState.FileLength))
                //                        {
                //                            TempItem.Text = "Only transfered " + TempState.BytesTransfered.ToString() + " bytes for file " + TempState.Filename + " to remote host " + TempState.RemoteIPAddress;
                //                        }
                //                        else
                //                        {
                //                            long TotalTime = (Process.CurrState.StopTransferTicks - Process.CurrState.StartTransferTicks) / 10000000;
                //                            long Rate = Rate = Process.CurrState.Filesize;

                //                            if (TotalTime > 0)
                //                            {
                //                                Rate = Process.CurrState.Filesize / TotalTime;
                //                            }

                //                            if (TempState.TransferType == 1)
                //                                TempItem.Text = "Successfully sent file " + TempState.Filename + " (" + Process.CurrState.Filesize.ToString() + " bytes) to " + TempState.RemoteIPAddress + " in " + TotalTime.ToString() + " seconds (" + (Rate).ToString() + " bytes/sec).";
                //                            else if (TempState.TransferType == 2)
                //                                TempItem.Text = "Successfully received file " + TempState.Filename + " (" + Process.CurrState.Filesize.ToString() + " bytes) from " + TempState.RemoteIPAddress + " in " + TotalTime.ToString() + " seconds (" + (Rate).ToString() + " bytes/sec).";
                //                        }
                //                        DeleteList.Add(ProcessIndex);
                //                    }
                //                    else
                //                    {
                //                        if (TempState.TransferType == 1)
                //                        {
                //                            double tester = Math.Round((Convert.ToDouble(TempState.BytesTransfered) / Convert.ToDouble(TempState.FileLength)) * 100);
                //                            TempItem.Text = "Remote host " + TempState.RemoteIPAddress + " is retrieving file " + TempState.Filename + " " + tester.ToString() + "%";
                //                        }
                //                        else if ((TempState.TransferType == 2) && (Process.CurrState.TransferSizeOption))
                //                        {
                //                            double tester = Math.Round((Convert.ToDouble(TempState.BytesTransfered) / Convert.ToDouble(Process.CurrState.Filesize)) * 100);
                //                            TempItem.Text = "Remote host " + TempState.RemoteIPAddress + " is sending file " + TempState.Filename + " " + tester.ToString() + "%";
                //                        }
                //                        else if (TempState.TransferType == 2)
                //                            TempItem.Text = "Remote host " + TempState.RemoteIPAddress + " is sending file " + TempState.Filename + " " + TempState.BytesTransfered.ToString() + " bytes received";
                //                    }
                //                }
                //            }
                //            else
                //            {
                //            }
                //        }
                //    }
                //}

                //for (int i = DeleteList.Count - 1; i >= 0; i--)
                //{
                //    Processes.RemoveAt((int)DeleteList[i]);
                //}
            //}
            //}
            //catch (Exception ex)
            //{
            //    MessageBox.Show(ex.Message + "\n" + ex.Source + "\n" + ex.StackTrace);
            //}
        }

    }
}
