﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;

using Comzept.Genesis.NetworkTools;
/*
   TFTPClient t = new TFTPClient("127.0.0.1");
   t.Put(@"test.zip", @"c:\Temp\MyDemoFileWrite.zip");
   t.Get(@"test.zip", @"c:\temp\MyDemoFileRead.zip");
*/
namespace tftpClient
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        public void fillIPlist()
        {
            IPHostEntry localMachineInfo = Dns.GetHostEntry(Dns.GetHostName());
            foreach (IPAddress addr in localMachineInfo.AddressList)
            {
                if (addr.AddressFamily == System.Net.Sockets.AddressFamily.InterNetwork)
                {
                    cboInterface.Items.Add(addr.ToString());
                }
            }
            cboInterface.SelectedIndex = 0;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            fillIPlist();
        }

        private void btnFileSelect_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.CheckFileExists = true;
            ofd.CheckPathExists = true;
            ofd.Filter = "All files (*.*)|*.*";
            ofd.RestoreDirectory = true;
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                txtFileNameLocal.Text = ofd.FileName;
            }
        }

        private void btnPut_Click(object sender, EventArgs e)
        {
            if (txtFileNameRemote.Text.Length == 0)
            {
                txtFileNameRemote.Text = System.IO.Path.GetFileName(txtFileNameRemote.Text);
            }
            if (!System.IO.File.Exists(txtFileNameLocal.Text))
                return;
            IPAddress ip;
            try
            {
                 ip = IPAddress.Parse(txtIP.Text);
            }
            catch (Exception)
            {
                txtIP.Focus();
                return;
            }
            Cursor.Current = Cursors.WaitCursor;
            Application.DoEvents();
            try
            {
                TFTPClient tftp = new TFTPClient(txtIP.Text);
                tftp.Put(txtFileNameRemote.Text, txtFileNameLocal.Text);
                MessageBox.Show("PUT finished");
            }
            catch (TFTPClient.TFTPException tx)
            {
                MessageBox.Show("Exception in PUT: " + tx.Message);
                Cursor.Current = Cursors.Default;
            }
            Cursor.Current = Cursors.Default;
            Application.DoEvents();
        }

        private void cboInterface_SelectedIndexChanged(object sender, EventArgs e)
        {
            txtIP.Text = (string)cboInterface.Items[cboInterface.SelectedIndex];
        }

        private void btnGet_Click(object sender, EventArgs e)
        {
            if (txtFileNameRemote.Text.Length != 0)
            {
                txtFileNameRemote.Text = System.IO.Path.GetFileName(txtFileNameRemote.Text);
            }
            else
                return;
            if (txtFileNameLocal.Text.Length == 0)
                return;

            IPAddress ip;
            try
            {
                 ip = IPAddress.Parse(txtIP.Text);
            }
            catch (Exception)
            {
                txtIP.Focus();
                return;
            }
            Cursor.Current = Cursors.WaitCursor;
            Application.DoEvents();
            try
            {
                TFTPClient tftp = new TFTPClient(txtIP.Text);
                tftp.Get(txtFileNameRemote.Text, txtFileNameLocal.Text);
                MessageBox.Show("GET finished");
            }
            catch (TFTPClient.TFTPException tx)
            {
                Cursor.Current = Cursors.Default;
                MessageBox.Show("Exception in GET: " + tx.Message);
            }
            Cursor.Current = Cursors.Default;
            Application.DoEvents();

        }

    }
}
