// KeyToggleCtrl.cpp : Defines the entry point for the application.
//

//history
//version   change
/*
  
  4.0		initial release of KeyToggleCtrl
			special release for mapping
			Gold+1, Gold+2, Gold+3 and Gold+4 into Ctrl+X, Ctrl+W, Ctrl+T and Ctrl+E.
			This one maps 1 2 3 4 to Ctrl+x Ctrl+w Ctrl+t Ctrl+e
			(31 -> 
			// VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A)
			x = 0x58
			w = 0x57
			t = 0x54
			e = 0x45
  3.0       added code for read/write reg for CharTable and KeyTable
                REGEDIT4

                [HKEY_LOCAL_MACHINE\Software\Intermec\KeyToggleCtrl]
                "KeyTable"=hex:\
                      30,31,32,33,34,35,36,37,38,39
                "CharTable"=hex:\
                      C6,00,E6,00,D8,00,F8,00,C5,00,E5,00,C2,00,E2,00,C4,00,E4,00
                "LEDid"=dword:00000001
                "autoFallback"=dword:00000000
                "Timeout"=dword:00000003
                "StickyKey"=dword:00000074

            KeyTable holds a list of 10 keys which will be 'remapped'
            CharTable holds  list of UniChar codes to use as replacement
            LEDid defines the ID of the LED to use for showing sticky state
            autoFallback defines, if the sticky state is reset after a mapped key is pressed. 
                         Use 0, if you dont want the sticky state to fallback after keypress
            TimeOut defines a timout after which sticky state will be reset

  2.2       added ReadReg code for LEDid
  ========== new code is now KeytoggleChar to enable creation of special chars (no function keys)
  2.1.1     ~
            changed code to catch sticky key
  2.1       +
            Added Registry code to read vars from Reg
            [HKEY_LOCAL_MACHINE\SOFTWARE\Intermec\KeyToggle]
            StickyKey = DWORD   defines the VK_ Value for the Sticky Key, default is VK_NUMLOCK is 0x90
            Timeout = DWORD     defines the time the sticky key is active, specify in seconds!, default is 3
            autoFallback = DWORD    defines, if the sticky state is reset after a number key is pressed
            +
            Added code for LEDs
            -
  2.0       initial release, started from iHook3
*/
//  ReportEvent

#include "stdafx.h"
#include "hooks.h"
#include "registry.h"
#include "resource.h"
#include  <nled.h>
#include "keybd_.h"
#include "tools.h"
#include "keymap.h"

DWORD vkSticky = VK_PERIOD; //the key to act on
UINT  stickyTimeout = 3000;  //if zero, no autofallback
DWORD autoFallback = 0;      //if 1 pressing a number after the sticky key will reset sticky state

TCHAR szAppName[] = L"KeyToggleCtrls v3.0";
// some unicode chars (http://www.unicode.org/charts/charindex.html)
WORD    charTable[] = { 0x0043, 0x0058, 0x0057, 0x0054, 0x0045, 0x0058, 0x0057, 0x0054, 0x0045, 0x0056 };
//                       C       X       W       T       E       X       W       T       E       V
TCHAR*  pCharTable=(TCHAR*) charTable;
// some vkeys (0 to 9)
byte keyTable[] = { 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39 };

LONG FAR PASCAL WndProc (HWND , UINT , UINT , LONG) ;
int ReadReg();
void WriteReg();

static bool isStickyOn=false;
static int tID=1011; //TimerID

NOTIFYICONDATA nid;

// Global variables can still be your...friend.
HINSTANCE g_hInstance       = NULL;         // Handle to app calling the hook (me!)
HINSTANCE  g_hHookApiDLL    = NULL;         // Handle to loaded library (system DLL where the API is located)

//ITC 7xx supports 5 LEDs?
//using 0 gives slow responsive by left amber LED light
//using 1 gives slow responsive by left red LED light
//using 2 gives immediate left red LED light
//using 3 gives immediate left green LED light
//using 4 gives slow responsive right green LED light

int LEDid=1; //which LED to use

// Global functions: The original Open Source
BOOL g_HookDeactivate();
BOOL g_HookActivate(HINSTANCE hInstance);

//
void ShowIcon(HWND hWnd, HINSTANCE hInst);
void RemoveIcon(HWND hWnd);

#pragma data_seg(".HOOKDATA")                                   //  Shared data (memory) among all instances.
    HHOOK g_hInstalledLLKBDhook = NULL;                     // Handle to low-level keyboard hook
#pragma data_seg()

#pragma comment(linker, "/SECTION:.HOOKDATA,RWS")       //linker directive

// from the platform builder <Pwinuser.h>
extern "C" {
BOOL WINAPI NLedGetDeviceInfo( UINT     nInfoId, void   *pOutput );
BOOL WINAPI NLedSetDevice( UINT nDeviceId, void *pInput );
};


//control the LEDs
void LedOn(int id, int onoff) //onoff=0 LED is off, onoff=1 LED is on
{
    TCHAR str[MAX_PATH];
    wsprintf(str,L"Trying to set LED with ID=%i to state=%i\n", id, onoff);
    DEBUGMSG(true,(str));
    /*  
    struct NLED_COUNT_INFO {
      UINT cLeds; 
    };*/
    NLED_COUNT_INFO cInfo;
    memset(&cInfo, 0, sizeof(cInfo));
    NLedGetDeviceInfo(NLED_COUNT_INFO_ID, &cInfo);
    if (cInfo.cLeds == 0)
    {
        DEBUGMSG(true,(L"NO LEDs supported!"));
        return;
    }
    else
    {
        wsprintf(str,L"Device supports %i LEDs\n",cInfo.cLeds);
        DEBUGMSG(true,(str));
    }

    NLED_SETTINGS_INFO settings; 
    memset(&settings, 0, sizeof(settings));
    settings.LedNum= id;
    /*  0 Off 
        1 On 
        2 Blink */
    settings.OffOnBlink= onoff;
    if (!NLedSetDevice(NLED_SETTINGS_INFO_ID, &settings))
        DEBUGMSG(true,(L"NLedSetDevice(NLED_SETTINGS_INFO_ID) failed"));
    else
        DEBUGMSG(true,(L"NLedSetDevice(NLED_SETTINGS_INFO_ID) success"));
}

//timer proc which resets isStickyOn after a period
VOID CALLBACK Timer2Proc(
                        HWND hWnd, // handle of window for timer messages
                        UINT uMsg,    // WM_TIMER message
                        UINT idEvent, // timer identifier
                        DWORD dwTime  // current system time
                        )

{
    isStickyOn=false;
    KillTimer(NULL, tID);
    LedOn(LEDid,0);
}

BOOL ClipboardCopy(const TCHAR *text)
{
    if (!OpenClipboard(0)) return FALSE;
    int len = wcslen(text) + 1;
    
    HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, len * sizeof(TCHAR));
    if (!hGlobal) { CloseClipboard(); return FALSE; }

    EmptyClipboard();

    TCHAR *dest = (TCHAR *)GlobalLock(hGlobal); 
    memcpy(dest, text, len * sizeof(TCHAR));
    GlobalUnlock(hGlobal); 

    BOOL res = SetClipboardData(CF_TEXT, hGlobal) != NULL;
    CloseClipboard();
 
    return res;
}

BOOL isVkeyInTable(byte bKey){
    for(int i=0; i<sizeof(keyTable); i++){
        if (keyTable[i] == bKey){
            DEBUGMSG(1, (L"Found vKey to remap\n"));
            return TRUE;
        }
    }
    DEBUGMSG(1, (L"Got vKey outside index\n"));
    return FALSE;
}

TCHAR getCharForKey(byte bKey){
    int pos=-1;
    for(int i=0; i<sizeof(keyTable); i++){
        if(keyTable[i]==bKey)
            pos=i;
    }
    if(pos>-1)
        return (TCHAR) charTable[pos];
    else
        return L' ';
}

//vkey is the original key
void eventKey(UINT vKey, WPARAM wParam, byte bModifier){
	DEBUGMSG(1, (L"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n"));
	DEBUGMSG(1, (L"Entering eventKey: vKey=0x%0x, wParam=0x%0x, Modifier=0x%0x\n", vKey, wParam, bModifier));
    TCHAR str[MAX_PATH];
	DWORD dwFlag8=0x80000001;
	DWORD dwFlagC=0xC0000001;
	/*  
	lParam=0x80000001 = 10000000.00000000.00000000.00000001
	lParam=0xc0000001 = 11000000.00000000.00000000.00000001
	                     ^=previous keystate flag
	control+w and ctrl+x:
	KEYDOWN VK_CONTROL 0x11 1
	KEYDOWN 00000057    1
	CHAR    (0x17) 1
	KEYUP   00000057    80000001
	KEYUP   VK_CONTROL 0x11 c0000001

	KEYDOWN VK_CONTROL 0x11 1
	KEYDOWN 00000058    1
	CHAR    (0x18) 1
	KEYUP   00000058    80000001
	KEYUP   VK_CONTROL 0x11 c0000001

	from app:
	KEYDOWN VK_CONTROL 0x11 1
	KEYDOWN 00000057    1
	CHAR    (0x17) 1
	KEYUP   00000057    c0000001
	KEYUP   VK_CONTROL 0x11 c0000001

	KEYDOWN VK_CONTROL 0x11 1
	KEYDOWN 00000058    1
	CHAR    (0x18) 1
	KEYUP   00000058    c0000001
	KEYUP   VK_CONTROL 0x11 c0000001
	*/
    UINT newKey = getCharForKey(vKey); // charTable[vKey-0x30];// 0x00c6; //AE
	DEBUGMSG(1, (L"getCharForKey: newKey=0x%0x\n", newKey));

	//chars ' ' thru z
	//WARNING only 0-9, a-z is equal to VK_0-VK_9 and VK_A-VK_Z
	//the REST must be translated! ie 
	//ASCII ';' 0x3B to VK_SEMICOLON 0xBA !!!!!!!!!
	//ASCII '$' to VK_SHIFT + VK_4 !!!!!!!!
	BYTE bCode=(char)newKey;
	BYTE vCode=vkTable[bCode].kVKval; //the VKEY value for the char
	BOOL bShift=vkTable[bCode].kShift;
	DEBUGMSG(1, (L"vkTable: vCode=0x%0x\n", vCode));

	//keybd_event(vKey, scanCode,flasg,extra)
    //create a new key event
	if (wParam == WM_KEYDOWN){
		if(bModifier==VK_CONTROL){
			keybd_event(bModifier, 0, 0, 0);// press modifier, ie VK_CONTROL
		}
		//if (bShift) //has to be shifted?
		//	keybd_event(VK_SHIFT, 0, KEYEVENTF_SILENT, 0); 
        //keybd_event((byte)newKey, 0, KEYEVENTF_SILENT, 0); //key_down
		keybd_event((byte)vCode, 0, KEYEVENTF_SILENT, 0); //key_down
	}
	if (wParam == WM_KEYUP){
        //keybd_event((byte)newKey, 0, KEYEVENTF_KEYUP |  KEYEVENTF_SILENT, 0); //key_up
		keybd_event((byte)vCode, 0, KEYEVENTF_KEYUP |  KEYEVENTF_SILENT, 0);//dwFlag8); //key_up
		//if (bShift) //has to be unshifted?
		//	keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP | KEYEVENTF_SILENT, 0); 
		if(bModifier==VK_CONTROL){
			keybd_event(bModifier, 0x9d, KEYEVENTF_KEYUP |  KEYEVENTF_SILENT, 0);// press modifier, ie VK_CONTROL
		}
	}
    DEBUGMSG(1,(L"old Key=0x%0x -> new vCode=\t0x%0x \n", vKey, vCode));
    DEBUGMSG(1,(L"Leaving eventKey\n", vKey, vCode));
    DEBUGMSG(1,(L"------------------------------------------------------------\n"));
}


void sendKey(UINT vKey){
    TCHAR* lpText;
    lpText = new TCHAR[MAX_PATH];
    TCHAR strClass[MAX_PATH];
    int iRes;

    HWND hWndActive = GetForegroundWindow();
    GetWindowText(hWndActive, lpText, MAX_PATH-1);
    iRes = GetClassName(hWndActive, strClass, MAX_PATH);
    DEBUGMSG(1, (L"GetForegroundWindow, handle=0x%x, text='%s', class='%s'\n", hWndActive, lpText, strClass));

    // hWndActive = GetFocusEx(); // a trick that does not deliver the focusses window
    hWndActive = GetForegroundKeyboardTarget();

    GetWindowText(hWndActive, lpText, MAX_PATH-1);
    iRes = GetClassName(hWndActive, strClass, MAX_PATH);
    DEBUGMSG(1, (L"### GetFocusEx() window, handle=0x%x, text='%s', class='%s'\n", hWndActive, lpText, strClass));

    if(hWndActive == NULL)
        return; //no window found

    WPARAM wParam = getCharForKey(vKey); // charTable[vKey-0x30];// 0x00c6; //AE
    LPARAM lParam = 1; //flags: repeat=1

/*
    wm_keydown, wParam=0, lParam=1
    wm_char, wParam=char code, lParam=1
    wm_keyup, wParam=0, lParam=c0000001;
*/

    LRESULT lRes=0;
    lRes = SendMessage(hWndActive, WM_KEYDOWN, 0, 1);
    DEBUGMSG(1, (L"SendMessage1 for 'WM_KEYDOWN' returned 0x%0x\n", lRes));
    lRes = SendMessage(hWndActive, WM_CHAR, wParam, 1);
    DEBUGMSG(1, (L"SendMessage2 for '0x%04x' returned 0x%0x\n", wParam, lRes));
    lRes = SendMessage(hWndActive, WM_KEYUP, 0, 0xc0000001);
    DEBUGMSG(1, (L"SendMessage3 for 'WM_KEYUP' returned 0x%0x\n", lRes));

    return;
}

void sendCtrlKey(UINT vKey){
    TCHAR* lpText;
    lpText = new TCHAR[MAX_PATH];
    TCHAR strClass[MAX_PATH];
    int iRes;

    HWND hWndActive = GetForegroundWindow();
    GetWindowText(hWndActive, lpText, MAX_PATH-1);
    iRes = GetClassName(hWndActive, strClass, MAX_PATH);
    DEBUGMSG(1, (L"GetForegroundWindow, handle=0x%x, text='%s', class='%s'\n", hWndActive, lpText, strClass));

    // hWndActive = GetFocusEx(); // a trick that does not deliver the focusses window
    hWndActive = GetForegroundKeyboardTarget();

    GetWindowText(hWndActive, lpText, MAX_PATH-1);
    iRes = GetClassName(hWndActive, strClass, MAX_PATH);
    DEBUGMSG(1, (L"### GetFocusEx() window, handle=0x%x, text='%s', class='%s'\n", hWndActive, lpText, strClass));

    if(hWndActive == NULL)
        return; //no window found

    WPARAM wParam = getCharForKey(vKey); // charTable[vKey-0x30];// 0x00c6; //AE
    LPARAM lParam = 1; //flags: repeat=1

/*
    wm_keydown, wParam=0, lParam=1
    wm_char, wParam=char code, lParam=1
    wm_keyup, wParam=0, lParam=c0000001;
*/

    LRESULT lRes=0;
	//ctrl key
	lRes = SendMessage(hWndActive, WM_SYSKEYDOWN, 0x9d, 0xc09d0001);
    DEBUGMSG(1, (L"SendMessage0 for 'WM_KEYDOWN' returned 0x%0x\n", lRes));

	lRes = SendMessage(hWndActive, WM_CHAR, wParam, 1);
    DEBUGMSG(1, (L"SendMessage2 for '0x%04x' returned 0x%0x\n", wParam, lRes));
    lRes = SendMessage(hWndActive, WM_KEYUP, 0, 0xc0000001);
    DEBUGMSG(1, (L"SendMessage3 for 'WM_KEYUP' returned 0x%0x\n", lRes));

	//ctrl key
	lRes = SendMessage(hWndActive, WM_SYSKEYUP, 0x9d, 0xc09d0001);
    DEBUGMSG(1, (L"SendMessage4 for 'WM_KEYUP' returned 0x%0x\n", lRes));

    return;
}

void postKey(byte bKey){

    UINT  uCharacter = (UINT)getCharForKey(bKey);// uChar;
    UINT  nShiftState;

    BOOL bRes=0;
    HWND hWndActive = GetForegroundKeyboardTarget();
    TCHAR szWinText[MAX_PATH];
    GetWindowText(hWndActive, szWinText, MAX_PATH-1);

    DEBUGMSG(1, (L"Found window, handle=0x%x, text='%s'\n", hWndActive, szWinText));

    // using PostKeybdMessage with HWND = -1 should post to 
    // active window or foreground thread focused window
    hWndActive = (HWND) -1;

    nShiftState = KeyStateDownFlag;//  | KeyShiftNoCharacterFlag;

    // looks like we only have to send one message
/*
    // using PostKeybdMessage with vKey scan code = 0
    bRes = PostKeybdMessage(hWndActive, 0, nShiftState, 1, &nShiftState, &uCharacter);
    if(bRes)
        DEBUGMSG(1, (L"PostKeybdMessage1 OK\n"));
    else
        DEBUGMSG(1, (L"PostKeybdMessage1 FAILED\n"));
*/
    nShiftState &= ~KeyStateDownFlag;
    nShiftState |= KeyStatePrevDownFlag;

    bRes = PostKeybdMessage(hWndActive, /* uCharacter */ 0, nShiftState, 1, &nShiftState, &uCharacter);
    if(bRes)
        DEBUGMSG(1, (L"PostKeybdMessage2 OK\n"));
    else
        DEBUGMSG(1, (L"PostKeybdMessage2 FAILED\n"));

}

void postCtrlKey(byte bKey){

    UINT  uCharacter = (UINT)getCharForKey(bKey);// uChar;
    UINT  nShiftState;
	KEY_STATE_FLAGS keyFlags;

    BOOL bRes=0;
    HWND hWndActive = GetForegroundKeyboardTarget();
    TCHAR szWinText[MAX_PATH];
    GetWindowText(hWndActive, szWinText, MAX_PATH-1);

    DEBUGMSG(1, (L"Found window, handle=0x%x, text='%s'\n", hWndActive, szWinText));

    // using PostKeybdMessage with HWND = -1 should post to 
    // active window or foreground thread focused window
    //hWndActive = (HWND) -1;

    nShiftState = KeyStateDownFlag;//  | KeyShiftNoCharacterFlag;
	nShiftState |= KeyShiftLeftCtrlFlag;

    // using PostKeybdMessage with vKey scan code = 0
    bRes = PostKeybdMessage(hWndActive, 0, nShiftState, 1, &nShiftState, &uCharacter);
    if(bRes)
        DEBUGMSG(1, (L"PostKeybdMessage1 OK\n"));
    else
        DEBUGMSG(1, (L"PostKeybdMessage1 FAILED\n"));

    nShiftState &= ~KeyStateDownFlag;
    nShiftState |= KeyStatePrevDownFlag;

    bRes = PostKeybdMessage(hWndActive, 0, nShiftState, 1, &nShiftState, &uCharacter);
    if(bRes)
        DEBUGMSG(1, (L"PostKeybdMessage2 OK\n"));
    else
        DEBUGMSG(1, (L"PostKeybdMessage2 FAILED\n"));

}


// The command below tells the OS that this EXE has an export function so we can use the global hook without a DLL
__declspec(dllexport) LRESULT CALLBACK g_LLKeyboardHookCallback(
   int nCode,      // The hook code
   WPARAM wParam,  // The window message (WM_KEYUP, WM_KEYDOWN, etc.)
   LPARAM lParam   // A pointer to a struct with information about the pressed key
) 
{
    /*  typedef struct {
        DWORD vkCode;
        DWORD scanCode;
        DWORD flags;
        DWORD time;
        ULONG_PTR dwExtraInfo;
    } KBDLLHOOKSTRUCT, *PKBDLLHOOKSTRUCT;*/
    
    // Get out of hooks ASAP; no modal dialogs or CPU-intensive processes!
    // UI code really should be elsewhere, but this is just a test/prototype app
    // In my limited testing, HC_ACTION is the only value nCode is ever set to in CE
    static int iActOn = HC_ACTION;
    TCHAR str[MAX_PATH];
    PKBDLLHOOKSTRUCT pkbhData = (PKBDLLHOOKSTRUCT)lParam;
    DWORD vKey;
    if ((lParam & LLKHF_INJECTED) == LLKHF_INJECTED)
        DEBUGMSG(1, (L"#### got injected key msg ####\n"));
    
    //is this code processed from foreign window?
    HWND hWndActive = GetActiveWindow();
    DEBUGMSG(1, (L"GetActiveWindow is 0x%0x\n", hWndActive));

    if (nCode == iActOn) 
    { 
#ifdef DEBUG
        //is this code processed from foreign window?
        hWndActive = GetActiveWindow(); 
        DEBUGMSG(1, (L"GetActiveWindow is 0x%0x\n", hWndActive));

            wsprintf(str, L"vkCode=\t0x%0x \n", pkbhData->vkCode);
            DEBUGMSG(true,(str));
            wsprintf(str, L"scanCode=\t0x%0x \n", pkbhData->scanCode);
            DEBUGMSG(true,(str));
            wsprintf(str, L"flags=\t0x%0x \n", pkbhData->flags);
            DEBUGMSG(true,(str));
            wsprintf(str, L"isStickyOn is=\t0x%0x \n", isStickyOn);
            DEBUGMSG(true,(str));
#endif
        //only process unflagged keys
        if (pkbhData->flags != 0x00)
            return CallNextHookEx(g_hInstalledLLKBDhook, nCode, wParam, lParam);

        //only process these types
        if ((wParam == WM_KEYUP) || (wParam == WM_KEYDOWN) || (wParam == WM_CHAR))
        {
            //dont care about sticky key down. v2.1.1
            if  ( (pkbhData->vkCode == vkSticky) && (wParam == WM_KEYDOWN) )
            {
                return -1;
            }
            
            //if num active change numeric keys to function keys
            //if sticky key set isStickyOn to active and start a timer to reset num after 3 seconds
            if  (
                (pkbhData->vkCode == vkSticky) && 
                (isStickyOn==false) && 
                (wParam == WM_KEYUP)
                )
            {
                LedOn(LEDid,1);
                isStickyOn=true;
                //start a timer
                if (stickyTimeout!=0)
                    tID=SetTimer(NULL, 0, stickyTimeout, (TIMERPROC)Timer2Proc);
                return -1;
            }
            //if isStickyOn and sticky key is again pressed, toggle isStickyOn to OFF
            if ((pkbhData->vkCode == vkSticky) && (isStickyOn==true) && (wParam == WM_KEYUP))
            {
                LedOn(LEDid,0);
                isStickyOn=false;
                //start a timer
                if (stickyTimeout!=0)
                    KillTimer(NULL, tID);
                return -1;
            }

            if ( (isStickyOn==true) && isVkeyInTable((byte)pkbhData->vkCode) )
            {
                //number key pressed and isStickyOn is active
                //get the pressed key
                vKey=pkbhData->vkCode;

				if ((wParam == WM_KEYUP) || (wParam == WM_KEYDOWN)){
                    //use sendKey
                    //sendKey(vKey);  // SendMessage and WM_CHAR
					//sendCtrlKey(vKey);

                    // use postKey
                    //if (wParam == WM_KEYUP)
                    //postKey(vKey); // PostKeybdMessage and char
					//postCtrlKey(vKey); // PostKeybdMessage and char

                    // use WM_PASTE approach
                    //  if (ClipboardCopy(str))
                    //      SendMessage(hWndActive, WM_PASTE, 0, 0);

                    //use eventKey?????
                    // keydb_event only OK if you have a keyboard scancode for the new key
                    eventKey(vKey, wParam, VK_CONTROL); 
                }

                if ((autoFallback==1) && (wParam == WM_KEYUP)) //if autofallback
                {
                    LedOn(LEDid,0);
                    isStickyOn=false;
                    if (stickyTimeout!=0)
                        KillTimer(NULL, tID);
                }
                return -1;
            }
        }
    }
    return CallNextHookEx(g_hInstalledLLKBDhook, nCode, wParam, lParam);
}

BOOL g_HookActivate(HINSTANCE hInstance)
{
    // We manually load these standard Win32 API calls (Microsoft says "unsupported in CE")
    SetWindowsHookEx        = NULL;
    CallNextHookEx          = NULL;
    UnhookWindowsHookEx = NULL;

    // Load the core library. If it's not found, you've got CErious issues :-O
    //TRACE(_T("LoadLibrary(coredll.dll)..."));
    g_hHookApiDLL = LoadLibrary(_T("coredll.dll"));
    if(g_hHookApiDLL == NULL) return false;
    else {
        // Load the SetWindowsHookEx API call (wide-char)
        //TRACE(_T("OK\nGetProcAddress(SetWindowsHookExW)..."));
        SetWindowsHookEx = (_SetWindowsHookExW)GetProcAddress(g_hHookApiDLL, _T("SetWindowsHookExW"));
        if(SetWindowsHookEx == NULL) return false;
        else
        {
            // Load the hook.  Save the handle to the hook for later destruction.
            //TRACE(_T("OK\nCalling SetWindowsHookEx..."));
            g_hInstalledLLKBDhook = SetWindowsHookEx(WH_KEYBOARD_LL, g_LLKeyboardHookCallback, hInstance, 0);
            if(g_hInstalledLLKBDhook == NULL) return false;
        }

        // Get pointer to CallNextHookEx()
        //TRACE(_T("OK\nGetProcAddress(CallNextHookEx)..."));
        CallNextHookEx = (_CallNextHookEx)GetProcAddress(g_hHookApiDLL, _T("CallNextHookEx"));
        if(CallNextHookEx == NULL) return false;

        // Get pointer to UnhookWindowsHookEx()
        //TRACE(_T("OK\nGetProcAddress(UnhookWindowsHookEx)..."));
        UnhookWindowsHookEx = (_UnhookWindowsHookEx)GetProcAddress(g_hHookApiDLL, _T("UnhookWindowsHookEx"));
        if(UnhookWindowsHookEx == NULL) return false;
    }
    //TRACE(_T("OK\nEverything loaded OK\n"));
    return true;
}


BOOL g_HookDeactivate()
{
    //TRACE(_T("Uninstalling hook..."));
    if(g_hInstalledLLKBDhook != NULL)
    {
        UnhookWindowsHookEx(g_hInstalledLLKBDhook);     // Note: May not unload immediately because other apps may have me loaded
        g_hInstalledLLKBDhook = NULL;
    }

    //TRACE(_T("OK\nUnloading coredll.dll..."));
    if(g_hHookApiDLL != NULL)
    {
        FreeLibrary(g_hHookApiDLL);
        g_hHookApiDLL = NULL;
    }
    //TRACE(_T("OK\nEverything unloaded OK\n"));
    return true;
}


int WINAPI WinMain( HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPTSTR    lpCmdLine,
                    int       nCmdShow)
{
    MSG      msg      ;  
    HWND     hwnd     ;   
    WNDCLASS wndclass ; 

	//allow only one instance
	if(FindWindow(NULL, L"KeyToggleCtrl")!=NULL)
		return -2;

    if (IsIntermec() != 0)
    {
        MessageBox(NULL, L"This is not an Intermec! Program execution stopped!", L"Fatal Error", MB_OK | MB_TOPMOST | MB_SETFOREGROUND);
        return -1;
    }
    if (wcsstr(lpCmdLine, L"-writereg") != NULL)
        WriteReg();
    //allow only one instance!
    //obsolete, as hooking itself prevents multiple instances
/*  HWND hWnd = FindWindow (szAppName, NULL);    
    if (hWnd) 
    {        
        //SetForegroundWindow (hWnd);            
        return -1;
    }
*/

      wndclass.style         = CS_HREDRAW | CS_VREDRAW  ; 
      wndclass.lpfnWndProc   = WndProc ;
      wndclass.cbClsExtra    = 0 ;
      wndclass.cbWndExtra    = 0 ;
      wndclass.hInstance     = hInstance   ;
      wndclass.hIcon         = LoadIcon (NULL , L"appicon.ico") ;
      wndclass.hCursor       = LoadCursor (NULL , IDC_ARROW)  ; 
      wndclass.hbrBackground = (HBRUSH) GetStockObject (GRAY_BRUSH)  ;
      wndclass.lpszMenuName  = NULL              ;
      wndclass.lpszClassName = szAppName ; 

      RegisterClass (&wndclass) ;    
                                                  
    hwnd = CreateWindow (szAppName , L"KeyToggleCtrl" ,   
             WS_VISIBLE | WS_CAPTION | WS_SYSMENU | WS_OVERLAPPED,          // Style flags                         
             CW_USEDEFAULT,       // x position                         
             CW_USEDEFAULT,       // y position                         
             CW_USEDEFAULT,       // Initial width                         
             CW_USEDEFAULT,       // Initial height                         
             NULL,                // Parent                         
             NULL,                // Menu, must be null                         
             hInstance,           // Application instance                         
             NULL);               // Pointer to create
                          // parameters
     if (!IsWindow (hwnd)) 
         return 0; // Fail if not created.

    g_hInstance=hInstance;
    //show a hidden window
    ShowWindow   (hwnd , SW_HIDE); // nCmdShow) ;  
    UpdateWindow (hwnd) ;

    //Notification icon
    HICON hIcon;
    hIcon=(HICON) LoadImage (g_hInstance, MAKEINTRESOURCE (IHOOK_STARTED), IMAGE_ICON, 16,16,0);
    nid.cbSize = sizeof (NOTIFYICONDATA);
    nid.hWnd = hwnd;
    nid.uID = 1;
    nid.uFlags = NIF_ICON | NIF_MESSAGE;
    // NIF_TIP not supported    
    nid.uCallbackMessage = MYMSG_TASKBARNOTIFY;
    nid.hIcon = hIcon;
    nid.szTip[0] = '\0';
    BOOL res = Shell_NotifyIcon (NIM_ADD, &nid);
#ifdef DEBUG
    if (!res)
        ShowError(GetLastError());
#endif
    
    // TODO: Place code here.

      while (GetMessage (&msg , NULL , 0 , 0))   
        {
          TranslateMessage (&msg) ;         
          DispatchMessage  (&msg) ;         
        } 
                                                                              
    
      return msg.wParam ;
}

                                        
LONG FAR PASCAL WndProc (HWND hwnd   , UINT message , 
                         UINT wParam , LONG lParam)                
                            
{ 

  switch (message)         
  {
    case WM_CREATE:
        ReadReg();
        if (g_HookActivate(g_hInstance))
        {
            MessageBeep(MB_OK);
            //system bar icon
            //ShowIcon(hwnd, g_hInstance);
            //TRACE(_T("Hook loaded OK"));
        }
        else
        {
            MessageBeep(MB_ICONEXCLAMATION);
            MessageBox(hwnd, L"Could not hook. Already running a copy of KeyToggleCtrl? Will exit now.", L"KeyToggleCtrl", MB_OK | MB_ICONEXCLAMATION);
            PostQuitMessage(-1);
        }
        //TRACE(_T("Hook did not success"));

		AllKeys(TRUE); //does not work?!

		return 0;
        break;
    case WM_PAINT:
        PAINTSTRUCT ps;    
        RECT rect;    
        HDC hdc;     // Adjust the size of the client rectangle to take into account    
        // the command bar height.    
        GetClientRect (hwnd, &rect);    
        hdc = BeginPaint (hwnd, &ps);     
        DrawText (hdc, TEXT ("KeyToggleCtrl loaded"), -1, &rect,
            DT_CENTER | DT_VCENTER | DT_SINGLELINE);    
        EndPaint (hwnd, &ps);     
        return 0;
        break;
    case MYMSG_TASKBARNOTIFY:
            switch (lParam) {
                case WM_LBUTTONUP:
                    //ShowWindow(hwnd, SW_SHOWNORMAL);
                    SetWindowPos(hwnd, HWND_TOPMOST, 0,0,0,0, SWP_NOSIZE | SWP_NOREPOSITION | SWP_SHOWWINDOW);
                    if (MessageBox(hwnd, L"Hook is loaded. End hooking?", szAppName, 
                        MB_YESNO | MB_ICONQUESTION | MB_APPLMODAL | MB_SETFOREGROUND | MB_TOPMOST)==IDYES)
                    {
                        g_HookDeactivate();
                        Shell_NotifyIcon(NIM_DELETE, &nid);
                        PostQuitMessage (0) ; 
                    }
                    ShowWindow(hwnd, SW_HIDE);
                }
        return 0;
        break;
    case WM_DESTROY:
        //taskbar system icon
        //RemoveIcon(hwnd);
        MessageBeep(MB_OK);
        g_HookDeactivate();
        Shell_NotifyIcon(NIM_DELETE, &nid);
		AllKeys(FALSE);
        PostQuitMessage (0) ; 
        return 0            ;
        break;
  }

  return DefWindowProc (hwnd , message , wParam , lParam) ;
}

void WriteReg()
{
    DWORD rc=0;
    DWORD dwVal=0;
    rc = OpenCreateKey(L"Software\\Intermec\\KeyToggleCtrl");
    if (rc != 0)
        ShowError(rc);

    if (rc=OpenKey(L"Software\\Intermec\\KeyToggleCtrl") != 0)
        ShowError(rc);
    
    dwVal=VK_F5; 0x90;
    rc = RegWriteDword(L"StickyKey", &dwVal);
    if (rc != 0)
        ShowError(rc);
    
    dwVal=3;
    rc = RegWriteDword(L"Timeout", &dwVal);
    if (rc != 0)
        ShowError(rc);

    dwVal=0;
    rc = RegWriteDword(L"autoFallback", &dwVal);
    if (rc != 0)
        ShowError(rc);

    dwVal=1;
    rc = RegWriteDword(L"LEDid", &dwVal)==0;
    if (rc != 0)
        ShowError(rc);

    //char table
    dwVal=sizeof(charTable);
    rc = RegWriteBytes(L"CharTable", (byte*)&charTable, dwVal)==0;
    if (rc != 0)
        ShowError(rc);

    //vkey table
    dwVal=sizeof(keyTable);
    rc = RegWriteBytes(L"KeyTable", (byte*)&keyTable, dwVal)==0;
    if (rc != 0)
        ShowError(rc);

    CloseKey();
}

int ReadReg()
{
    //for keytoggle we need to read the stickyKey to react on
    //and the timout for the sticky key
    byte dw=0;
    DWORD dwVal=0;

    OpenKey(L"Software\\Intermec\\KeyToggleCtrl");

    //read the StickyKey to use
    if ((RegReadDword(L"StickyKey", &dwVal)==0) && dwVal!=0)
    {
        vkSticky = dwVal;
        DEBUGMSG(true,(L"Reading StickyKey from REG = OK\n"));
    }
    else
    {
        vkSticky = VK_NUMLOCK;
        DEBUGMSG(true,(L"Reading StickyKey from REG = FAILED, assigned VK_NUMLOCK\n"));
    }
    
    //read the timeout for the StickyKey
    if (RegReadDword(L"Timeout", &dwVal)==0)
    {
        stickyTimeout = (UINT) dwVal * 1000;
        DEBUGMSG(true,(L"Reading Timeout from REG = OK\n"));
    }
    else
    {
        stickyTimeout = 3 * 1000;
        DEBUGMSG(true,(L"Reading Timeout from REG = FAILED, assigned 3 seconds\n"));
    }

    //autoFallback
    //read the timeout for the StickyKey
    if (RegReadDword(L"autoFallback", &dwVal)==0)
    {
        autoFallback = dwVal;
        DEBUGMSG(true,(L"Reading autoFallback from REG = OK\n"));
    }
    else
    {
        autoFallback = 0;
        DEBUGMSG(true,(L"Reading autoFallback from REG = FAILED, NO autoFallback\n"));
    }

    //read LEDid to use for signaling
    if (RegReadDword(L"LEDid", &dwVal)==0)
    {
        LEDid = dwVal;
        DEBUGMSG(true,(L"Reading LEDid from REG = OK\n"));
    }
    else
    {
        LEDid = 1;
        DEBUGMSG(true,(L"Reading LEDid from REG = FAILED, NO autoFallback\n"));
    }

    // read keyboard translation table
    // vKeyIn -> Char out
    // read size, for 10 words we need 20 bytes

    int iSize=RegReadByteSize(L"CharTable", iSize);
	int iTableSizeIN=iSize;

    byte* bTemp = new byte[20];
    if(iSize!=20){ //0x14 = 20 bytes
        DEBUGMSG(1, (L"Failed reading CharTable, using default\n"));
    }
    else{
        if (RegReadBytes(L"CharTable", bTemp, sizeof(bTemp))==ERROR_SUCCESS){
            DEBUGMSG(1, (L"Read CharTable OK\n"));
            memcpy(charTable, bTemp, 20);
        }
        else{
            DEBUGMSG(1, (L"Failed reading CharTable, using default\n"));
        }
    }

	delete bTemp;
    bTemp=new byte[10];
    iSize=RegReadByteSize(L"KeyTable", iSize);
	int iTableSizeOUT=iSize;
    if(iSize!=10){ //0x14 = 20 bytes
        DEBUGMSG(1, (L"Failed reading KeyTable, using default\n"));
    }
    else{
        if (RegReadBytes(L"KeyTable", bTemp, sizeof(bTemp))==ERROR_SUCCESS){
            DEBUGMSG(1, (L"Read KeyTable OK\n"));
            memcpy(keyTable, bTemp, 10);
        }
        else{
            DEBUGMSG(1, (L"Failed reading KeyTable, using default\n"));
        }
    }

    CloseKey();
#ifdef DEBUG
	DEBUGMSG(1, (L"===========================\n"));
	for (int i=0; i<sizeof(keyTable); i++){
		DEBUGMSG(1, (L"Keytable %i 0x%02x -> 0x%04x, '%c' -> '%c'\n",i, keyTable[i], charTable[i], keyTable[i], charTable[i]));
	}
	DEBUGMSG(1, (L"===========================\n"));
#endif
    TCHAR str[MAX_PATH];
    wsprintf(str,L"\nReadReg: vkSticky=%i, Timeout=%i, Autofallback=%i, LEDid=%i\n",vkSticky,stickyTimeout,autoFallback,LEDid);
    DEBUGMSG(true,(str));
    return 0;
}

void ShowIcon(HWND hWnd, HINSTANCE hInst)
{
    NOTIFYICONDATA nid;

    int nIconID=1;
    nid.cbSize = sizeof (NOTIFYICONDATA);
    nid.hWnd = hWnd;
    nid.uID = nIconID;
    nid.uFlags = NIF_ICON | NIF_MESSAGE;   // NIF_TIP not supported
    nid.uCallbackMessage = MYMSG_TASKBARNOTIFY;
    nid.hIcon = (HICON)LoadImage (g_hInstance, MAKEINTRESOURCE (ID_ICON), IMAGE_ICON, 16,16,0);
    nid.szTip[0] = '\0';

    BOOL r = Shell_NotifyIcon (NIM_ADD, &nid);

}

void RemoveIcon(HWND hWnd)
{
    NOTIFYICONDATA nid;

    memset (&nid, 0, sizeof nid);
    nid.cbSize = sizeof (NOTIFYICONDATA);
    nid.hWnd = hWnd;
    nid.uID = 1;

    Shell_NotifyIcon (NIM_DELETE, &nid);

}