// WireLess.h

//extern TCHAR strMessage[MAX_PATH];
//extern int valMessage;
extern const WORD WM_UPDATESIGNAL; //


#define UNKNOWERROR -250
#define LOADLIBFAILED -251
#define CONNECTFAILED -252
#define QUERYFAILED -253
#define SCANNING -254
#define NOTASSOCIATED -255

int BatCapacity = 4200; //battery capacity

//for ITC devices
typedef HRESULT (*PFN_ITCPowerStatus)(LPDWORD lpdwLineStatus,LPDWORD lpdwBatteryStatus,LPDWORD lpdwBackupStatus,UINT *puFuelGauge);
static PFN_ITCPowerStatus ITCPowerStatus = NULL;
static HINSTANCE hLib;

/*
HRESULT ITCPowerStatus (
LPDWORD lpdwLineStatus,
LPDWORD lpdwBatteryStatus,
LPDWORD lpdwBackupStatus,
UINT *puFuelGauge
);
Parameters
lpdwLineStatus

[out] Returns the AC line status:
	ITC_ACLINE_NOT_CONNECTED AC line is not connected.
	ITC_ACLINE_CONNECTED AC line is connected.
	ITC_UNKNOWN_ACLINE AC line status is unknown.

lpdwBatteryStatus [out] Returns the main battery status:
	ITC_HIGH_BAT Battery charge is high.
	ITC_LOW_BAT Battery charge is low.
	ITC_CRITICAL_BAT Battery charge is critical.
	ITC_CHARGING_BAT Battery is charging now.
	ITC_NO_SYSTEM_BAT No system battery.
	ITC_UNKNOWN_BAT Battery condition is unknown.

lpdwBackupStatus [out] Returns the bridge battery status:
	ITC_HIGH_BACKUP Backup battery is high.
	ITC_LOW_BACKUP Backup battery is low.
	ITC_CRITICAL_BACKUP Backup battery is critical.
	ITC_CHARGING_BACKUP Backup battery is charging now.
	ITC_NO_SYSTEM_BACKUP No system backup battery.
	ITC_UNKNOWN_BACKUP Backup battery condition is unknown.

puFuelGauge [out] Returns percentage of remaining battery life:
	0 to 100: Percentage of battery charge. 
	255: Battery life is unknown.

*/

#define ITC_HIGH_BAT                     0x0191001BL
#define ITC_LOW_BAT                      0x0191001CL
#define ITC_CRITICAL_BAT                 0x0191001DL
#define ITC_CHARGING_BAT                 0x0191001EL
#define ITC_NO_SYSTEM_BAT                0x0191001FL
#define ITC_SUCCESS                      0x01910000L

HINSTANCE loadLib(){
	if(hLib==NULL)
		hLib = LoadLibrary(L"itc50.dll");
	if(hLib==NULL)
	{
		return NULL;
	}
	else{
		if(ITCPowerStatus == NULL){
			//PFN_ITCPowerStatus ITCPowerStatus = NULL;
			ITCPowerStatus = (PFN_ITCPowerStatus) GetProcAddress(hLib, _T("ITCPowerStatus"));
			if(ITCPowerStatus==NULL)
				return NULL;
			return hLib;
		}
		return hLib;
	}
}

//======================================================================
/*
	get Battery State: an alternative way of getting the battery state
	using [HKLM]System\State\Battery
	the DWORD there (for example 0x00510001
	right-to-left, the first four digits (i.e. 0x0001) constitute the
	PowerBatteryState and the remaining digits (i.e. 0x0051) constitute the
	PowerBatteryStrength
*/
ULONG getBattState(){
	HKEY hKey=NULL;
	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, L"System\\State\\Battery", 0, 0, &hKey)==ERROR_SUCCESS){
		DWORD	dwType=REG_DWORD;
		DWORD	dwData=0;
		DWORD*	pData=&dwData;
		DWORD	cData=sizeof(DWORD);
		if(RegQueryValueEx(hKey, L"Main", NULL, &dwType, (byte*) pData, &cData)==ERROR_SUCCESS){
			DEBUGMSG(1, (L"RegQueryValueEx=0x%08x\n", dwData));
			RegCloseKey(hKey);
			return LOWORD(dwData);	//lo is state: LOWORD(dwData);  and high is strength: HIWORD(dwData);
		}
		else{
			DEBUGMSG(1, (L"RegQueryValueEx() failed\n"));
			RegCloseKey(hKey);
			return BATTERY_FLAG_UNKNOWN;
		}
	}
	else{
		DEBUGMSG(1, (L"RegOpenKeyEx() failed\n"));
		return BATTERY_FLAG_UNKNOWN;
	}
}

//======================================================================
/*
	get Battery Status
	uses either ITCPowerStatus or GetSystemPowerStatusEx2
*/
ULONG getBattStatus(){

	if(loadLib()!=NULL){
		DWORD dwLineStatus=0;
		DWORD dwBatteryStatus=0;
		DWORD dwBackupStatus=0;
		UINT  uiFuelGauge;
		HRESULT hRes = ITCPowerStatus(&dwLineStatus, &dwBatteryStatus, &dwBackupStatus, &uiFuelGauge);
		#ifdef DEBUG
		TCHAR str[1024];
		wsprintf(str, L"\t%08x \t%08x \t%08x \t%04u \r\n",
					   dwLineStatus, dwBatteryStatus, dwBackupStatus, uiFuelGauge);
		DEBUGMSG(true, (L"%s", str));
		#endif
		if(hRes==ITC_SUCCESS){
			//we have to do some mapping
			switch(dwBatteryStatus){
				case ITC_HIGH_BAT:
					return 1;
				case ITC_LOW_BAT:
					return 2;
				case ITC_CRITICAL_BAT:
					return 4;
				case ITC_CHARGING_BAT:
					return 8;
				default:
					return 255;
			}
		}
		else{
			return 255;
		}
	}
	else{
		SYSTEM_POWER_STATUS_EX2 pwrs;
		int iRes = GetSystemPowerStatusEx2(&pwrs, sizeof(SYSTEM_POWER_STATUS_EX2), true);
		
		/*
		BYTE ACLineStatus;
		BYTE BatteryFlag;	
							1 High 
							2 Low 
							4 Critical 
							8 Charging 
							128 No system battery 
							255 Unknown status 

		BYTE BatteryLifePercent;
		BYTE Reserved1;
		DWORD BatteryLifeTime;
		DWORD BatteryFullLifeTime;
		BYTE Reserved2;
		BYTE BackupBatteryFlag;
		BYTE BackupBatteryLifePercent;
		BYTE Reserved3;
		DWORD BackupBatteryLifeTime;
		DWORD BackupBatteryFullLifeTime;
		// Above here is old struct, below are new fields
		DWORD BatteryVoltage; 				// Reports Reading of battery voltage in millivolts (0..65535 mV)
		DWORD BatteryCurrent;				// Reports Instantaneous current drain (mA). 0..32767 for charge, 0 to -32768 for discharge
		DWORD BatteryAverageCurrent; 		// Reports short term average of device current drain (mA). 0..32767 for charge, 0 to -32768 for discharge
		DWORD BatteryAverageInterval;		// Reports time constant (mS) of integration used in reporting BatteryAverageCurrent	
		DWORD BatterymAHourConsumed; 		// Reports long-term cumulative average DISCHARGE (mAH). Reset by charging or changing the batteries. 0 to 32767 mAH  
		DWORD BatteryTemperature;			// Reports Battery temp in 0.1 degree C (-3276.8 to 3276.7 degrees C)
		DWORD BackupBatteryVoltage;			// Reports Reading of backup battery voltage
		BYTE  BatteryChemistry; 		    // See Chemistry defines above
		*/

		//convert to hours and minutes: ie 13.50 => 13 hours and 30 Minutes
		double BatLife = (double)BatCapacity / (double)pwrs.BatteryCurrent;
		int hhBatLife = (int) BatLife;
		int mmBatLife = (int)(((BatLife - hhBatLife)*100) * 0.6);

		#ifdef DEBUG
		TCHAR str[1024];
		wsprintf(str, L"\t%04u \t%04u \t%04u \t%04u \t%04u \t%u \t%u \t%u \t%u \t%u \t%u \t%u \t%02i:%02i\r\n",
					   pwrs.ACLineStatus, pwrs.BatteryFlag, pwrs.BatteryLifePercent, 
					   pwrs.BackupBatteryFlag, pwrs.BackupBatteryLifePercent, 
					   pwrs.BatteryVoltage, pwrs.BatteryCurrent, pwrs.BatteryAverageCurrent, pwrs.BatteryAverageInterval, pwrs.BatterymAHourConsumed,
					   pwrs.BatteryTemperature, pwrs.BackupBatteryVoltage, hhBatLife, mmBatLife);
		DEBUGMSG(true, (L"%s", str));
		#endif

		if(iRes!=0)
			return pwrs.BatteryFlag;
		else
			return BATTERY_FLAG_UNKNOWN;
	}
}

int showTaskBar(bool bShow){
	HWND hWndTB=NULL;
	hWndTB = FindWindow(L"HHTaskBar", NULL);
	if (hWndTB != NULL){
		if(bShow)
			ShowWindow(hWndTB, SW_SHOW);
		else
			ShowWindow(hWndTB, SW_HIDE);
	}
	return 0;
}

int reorderTaskBar(HWND hWnd){
	return 0;

	HWND hWndTB=NULL;
	//hWndTB = GetDesktopWindow(); //other windows will not show, except for today screen!
	hWndTB = FindWindow(L"HHTaskBar", NULL);
	//GetWindow(hWndTB, GW_HWNDFIRST);
	if (hWndTB != NULL){
		SetWindowPos(hWndTB, hWnd, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
		return 0;
	}
	else 
		return -1;
}

int bringToFront(HWND hWnd){
	return SetWindowPos(hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
}


