// keyboard shift api for CN3, CN4 and CK3

#include <windows.h>
#include <winioctl.h>

#define FILE_DEVICE_KBD	0x8000		// First value available for use outside Microsoft

#define IOCTL_KBD_GET_SHIFT_STATE		CTL_CODE(FILE_DEVICE_KBD,  3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_KBD_SET_SHIFT_STATE		CTL_CODE(FILE_DEVICE_KBD, 12, METHOD_BUFFERED, FILE_ANY_ACCESS) 
#define IOCTL_KBD_GET_SHIFT_PLANES		CTL_CODE(FILE_DEVICE_KBD, 16, METHOD_BUFFERED, FILE_ANY_ACCESS)


const TCHAR KEYPAD_DEVICE_NAME[] = L"KBD1:";

BOOL ITCGetShiftState(DWORD *value, DWORD *locked)
{
   BOOL fRet = FALSE;
    DWORD actualSize;
    HANDLE hFile;
    DWORD params[2];

    // open keyboard interface
    if ((hFile = CreateFile(_T("KBD1:"), GENERIC_READ|GENERIC_WRITE, 0, NULL, 
      OPEN_EXISTING, 0, 0)) != INVALID_HANDLE_VALUE)
    {
        if ( DeviceIoControl(hFile, IOCTL_KBD_GET_SHIFT_STATE, NULL, 0, (void *)params,
             sizeof(DWORD)*2, &actualSize, NULL) )
        *value = params[0];
        *locked = params[1];
        fRet = TRUE;
        CloseHandle(hFile);
    }

    return fRet;

}

/*
        public static bool ITCGetShiftState(ref Int32 value, ref Int32 locked)
        {
            bool fRet = false;
            IntPtr hFile;
            Int32[] mParams = new Int32[2];
            uint IOCTL_KBD_GET_SHIFT_STATE = CTL_CODE(FILE_DEVICE_KBD, 3, NativeMethods.METHOD_BUFFERED, NativeMethods.FILE_ANY_ACCESS);

            // open keyboard interface
            if ((hFile = NativeMethods.CreateFile
                            ("KBD1:", NativeMethods.GENERIC_READ | NativeMethods.GENERIC_WRITE, 0,
                            IntPtr.Zero, ECreationDisposition.OpenExisting, 0, IntPtr.Zero)) != NativeMethods.INVALID_HANDLE_VALUE)
            {
                int[] inBuffer = new int[1];
                int bytesReturned = 0;
                int inSize = sizeof(Int32) * mParams.Length;

                if (NativeMethods.DeviceIoControl(hFile, (int)IOCTL_KBD_GET_SHIFT_STATE, null, 0, mParams, inSize,
                    ref bytesReturned, IntPtr.Zero))
                {
                    value = mParams[0];
                    locked = mParams[1];
                    fRet = true;
                }
                else
                    fRet = false;
                NativeMethods.CloseHandle(hFile);
            }

            return fRet;

        }
*/
int GetCurrentPlane()
{
	DWORD dwVal=0;
	DWORD dwLocked=0;
	if(ITCGetShiftState(&dwVal, &dwLocked))
		return dwVal;
	else
		return 255;
}