//cn50ShiftApi.h

#include <windows.h>
#include <winioctl.h>


	enum KeyBoardPlanes
	{
		Normal = 0,
		SP1 = 1,
		SP2 = 2,
		Unknown = 255
	};

const TCHAR KEYPAD_DEVICE_NAME[] = L"KBD1:";
const int IOCTL_SET_VK_KEYDOWN = (FILE_DEVICE_UNKNOWN << 16) | (FILE_ANY_ACCESS << 14) | (0x0100 << 2) | METHOD_BUFFERED;
const int IOCTL_SET_VK_KEYUP = (FILE_DEVICE_UNKNOWN << 16) | (FILE_ANY_ACCESS << 14) | (0x0101 << 2) | METHOD_BUFFERED;
const int IOCTL_KPD_GET_INPUT_PLANE = (FILE_DEVICE_UNKNOWN << 16) | (FILE_ANY_ACCESS << 14) | (0x0802 << 2) | METHOD_BUFFERED;

static void ToggleOrangePlane()
{

    BYTE key[1];// = new BYTE[1];
    key[0] = 0x99;

    unsigned long bytesreturned = 0;

    HANDLE hKpd = CreateFile(KEYPAD_DEVICE_NAME, 0, 0, NULL, 0, 0, NULL);

    if (hKpd != NULL)
    {

        DeviceIoControl(hKpd, IOCTL_SET_VK_KEYDOWN, key, 1, NULL, 0, &bytesreturned, NULL);
        DeviceIoControl(hKpd, IOCTL_SET_VK_KEYUP, key, 1, NULL, 0, &bytesreturned, NULL);
        CloseHandle(hKpd);
    }

}
static void ToggleGreenPlane()
{

    BYTE key[1];// = new byte[1];
    key[0] = 0x9A;

    unsigned long bytesreturned = 0;

    HANDLE hKpd = CreateFile(KEYPAD_DEVICE_NAME, 0, 0, NULL, 0, 0, NULL);

    if (hKpd != NULL)
    {

        DeviceIoControl(hKpd, IOCTL_SET_VK_KEYDOWN, key, 1, NULL, 0, &bytesreturned, NULL);
        DeviceIoControl(hKpd, IOCTL_SET_VK_KEYUP, key, 1, NULL, 0, &bytesreturned, NULL);
        CloseHandle(hKpd);
    }

}

int GetCurrentPlane()
{

    BYTE kbpRc = 255;

    BYTE* InputPlane = new BYTE[sizeof(int)];

    unsigned long bytesreturned = 0;
    int Rc = 0;

    HANDLE hKpd = CreateFile(KEYPAD_DEVICE_NAME, 0, 0, NULL, 0, 0, NULL);

    if (hKpd != NULL)
    {
        Rc = DeviceIoControl(hKpd, IOCTL_KPD_GET_INPUT_PLANE, NULL, 0, InputPlane, sizeof(int), &bytesreturned, NULL);
        if (Rc != 0)
        {
            kbpRc = (KeyBoardPlanes)InputPlane[0];
        }
        CloseHandle(hKpd);
    }
	delete (InputPlane);
    return kbpRc;
}

