// TaskbarAddon5.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "TaskbarAddon5.h"
#include <memory.h>

//==========================
//#include "Battery.h"
//#include "cn50ShiftApi.h"
//#include "cn3cn4ck3shiftapi.h"
//#include "watchWindowList.h"
#include "wireless.h"

//TCHAR strMessage[MAX_PATH];
//int   valMessage;
//==========================

#define MAX_LOADSTRING 100

//======================================================================
// 
// vars for the drawings 
// 
#define NEW_DIB_FORMAT(lpbih) (lpbih->biSize != sizeof(BITMAPCOREHEADER))

HBITMAP hbmError=NULL;
HBITMAP hbm0=NULL;
HBITMAP hbm1=NULL;
HBITMAP hbm2=NULL;
HBITMAP hbm3=NULL;
HBITMAP hbm4=NULL;

//colors
unsigned long colorRed=RGB(255,0,0);
unsigned long colorGreen=RGB(0,255,0);
unsigned long colorOrange=RGB(255, 128, 64);
unsigned long colorBlack=RGB(0,0,0);
unsigned long colorWhite=RGB(255,255,255);

unsigned long colorYellow=RGB(255,255,0);
unsigned long colorBackground=RGB(100,100,100);
unsigned long colorUnknown=RGB(50,50,50);

//control the taskbar?
#define CONTROL_TASKBAR
#undef CONTROL_TASKBAR

//hook taskbar?
#define HOOK_TASKBAR
#undef HOOK_TASKBAR

// Global Variables:
HINSTANCE	hInst;			// The current instance
TCHAR		szAppName[] = TEXT ("PopMenu") ;
TCHAR	szRegKey[] = L"Software\\TaskbarAddon5";

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE, LPTSTR);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About			(HWND, UINT, WPARAM, LPARAM);
HWND g_hWnd=NULL;

const WORD WM_UPDATESIGNAL = WM_USER + 1704;

//the options dlg
LRESULT CALLBACK Options(HWND, UINT, WPARAM, LPARAM);


//======================================================================
// 
// Static variables for task bar subclassing 
// 
static LRESULT CALLBACK TaskWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam); //CallBAck for TaskBar Hook
static HWND g_hWndTask = NULL; 
static WNDPROC g_fnProcTask = NULL; 

//======================================================================
#define FLOATWIDTH     24 //100 //200                     // Width of floating wnd
#define FLOATHEIGHT    24 //100 //100                     // Height of floating wnd

//======================================================================

//registry save
void saveReg(DWORD dwVal){
	HKEY hKeyRes;
	DWORD dwDispo=0;
	LONG lRes=0;

	//ensure the regKey exists
	lRes = RegCreateKeyEx(HKEY_LOCAL_MACHINE, szRegKey, 0, NULL, REG_OPTION_NON_VOLATILE, 0, NULL, &hKeyRes, &dwDispo);
	//RegOpenKeyEx(HKEY_LOCAL_MACHINE, szRegKey, 0,0, &hKey);
	if( lRes == ERROR_SUCCESS ){
		//save the value
		DWORD dwType = REG_DWORD;
		lRes = RegSetValueEx(hKeyRes, L"position", 0, dwType, (byte*)&dwVal, sizeof(DWORD));
		if(lRes != ERROR_SUCCESS)
			DEBUGMSG(1, (L"RegSetValueEx failed: lRes=0x%0x\n", lRes));
		RegCloseKey(hKeyRes);
	}
	else{
		DEBUGMSG(1, (L"RegCreateKeyEx failed: lRes=0x%0x\n", lRes));
	}
}

DWORD readReg(){
	DWORD dwVal=80;
	HKEY hKey;
	DWORD dwDispo=0;
	LONG lRes=0;

	//ensure the regKey exists
	lRes = RegOpenKeyEx(HKEY_LOCAL_MACHINE, szRegKey, 0,0, &hKey);
	if( lRes == ERROR_SUCCESS ){
		//load the value
		DWORD dwType = REG_DWORD;
		DWORD dwSize = sizeof(DWORD);
		lRes = RegQueryValueEx (hKey, L"position", 0, &dwType, (byte*) &dwVal, &dwSize);
		if(lRes != ERROR_SUCCESS)
			DEBUGMSG(1, (L"RegGetValueEx failed: lRes=0x%0x\n", lRes));
		RegCloseKey(hKey);
		return dwVal;
	}
	else{
		DEBUGMSG(1, (L"RegOpenKeyEx failed: lRes=0x%0x\n", lRes));
		return 80;
	}
}

// refereshing thread
bool bRunThread=true;
DWORD threadID=0;
HANDLE hThread = NULL;
DWORD WINAPI ThreadProc(LPVOID lpParam){
	static ULONG oldValue=0;
	ULONG uRet = 0;
	HWND theWnd = (HWND)lpParam;
	do{
		Sleep(3000);
		uRet = GetCurrentValue(); //will get status and then signal strength
		//DEBUGMSG(1, (L"ThreadProc-GetCurrentValue()=%i\n", uRet));
		//Send update message ONLY if update needed
		if(uRet!=oldValue){
			SendMessage(theWnd, WM_UPDATESIGNAL, (LPARAM)uRet, 0);
			oldValue=uRet;
		}

	}while(bRunThread);
	return 0;
}

//----------------------------------------------------------------------
//HOOK Into TaskBar WndProc
//
BOOL HookTaskBar() 
{ 
#ifndef HOOK_TASKBAR
	return TRUE;
#endif
	// 
	// Already hooked? 
	// 
	if(g_fnProcTask) 
		return FALSE; 
	g_hWndTask = FindWindow(_T("HHTaskBar"), NULL); 
	if(g_hWndTask) { 
		//g_hWndMain = g_hWnd; // GetSafeHwnd(); 
		g_fnProcTask = (WNDPROC)GetWindowLong(g_hWndTask, GWL_WNDPROC); 
		SetWindowLong(g_hWndTask, GWL_WNDPROC, (LONG)TaskWndProc); 
	} 
	return g_hWndTask != NULL; 
} 

//----------------------------------------------------------------------
BOOL UnhookTaskBar() 
{ 
#ifndef HOOK_TASKBAR
	return TRUE;
#endif
	// 
	// Already freed? 
	// 
	if(!g_fnProcTask) 
		return FALSE; 
	SetWindowLong(g_hWndTask, GWL_WNDPROC, (LONG)g_fnProcTask); 
	g_fnProcTask = NULL; 
	return TRUE; 
} 
int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TaskbarAddon5);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    It is important to call this function so that the application 
//    will get 'well formed' small icons associated with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW | CS_NOCLOSE | CS_DBLCLKS;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TaskbarAddon5));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(HOLLOW_BRUSH); //NULL; //make a transparent window //
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_TaskbarAddon5, szWindowClass, MAX_LOADSTRING);

	//allow only one instance
	if(FindWindow(szWindowClass, NULL) != NULL)
		return FALSE;

	MyRegisterClass(hInstance, szWindowClass);

	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	HWND hWndTaskbar=FindWindow(L"HHTaskBar", NULL);


	hWnd = CreateWindowEx(
		0, //WS_EX_TOPMOST | WS_EX_ABOVESTARTUP, 
		szWindowClass, 
		NULL /* szTitle */, 
		WS_VISIBLE, //WS_VISIBLE | WS_EX_ABOVESTARTUP, // | WS_EX_TOOLWINDOW | WS_CHILD | WS_POPUP | WS_NONAVDONEBUTTON, 
		0, 
		0, 
		FLOATWIDTH, 
		FLOATHEIGHT, 
		hWndTaskbar, // NULL, 
		NULL, 
		hInstance, 
		NULL);
	if (!hWnd)
	{	
		return FALSE;
	}

	g_hWnd = hWnd;

	
	hbmError = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_BITMAPERROR));
	hbm0 = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_BITMAP0));
	hbm1 = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_BITMAP1));
	hbm2 = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_BITMAP2));
	hbm3 = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_BITMAP3));
	hbm4 = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_BITMAP4));

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	
	LONG lStyle = GetWindowLong(hWnd, GWL_STYLE);
	DEBUGMSG(1, (L"GetWindowLong GWL_SYTLE=%08x\n", lStyle));
	DWORD dwLeft = readReg();
	SetWindowPos(hWnd, HWND_TOPMOST, dwLeft, 0, 0, 0, SWP_NOSIZE | SWP_SHOWWINDOW);
	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{

	int wmId, wmEvent;

	static int iSignal=0;

	static HMENU hMenu ;
	POINT        point ;

	static HBRUSH hbrBlack, hbrBackground, hbrRed, hbrYellow, hbrGreen, hbrUnknown, hbrOrange;
	static HPEN hPen;
	unsigned long fillColor = colorBlack;

	int x, y;
	PAINTSTRUCT ps;
	RECT rt;
	HDC hdc;
	HDC hdcMem=NULL;
	HBITMAP hbmOld = NULL;

	LONG wStyleEx=0;
	LONG wStyle=0;
	
	int iRes = 0;
	int percent=0;

	switch (message) 
	{
#ifdef CONTROL_TASKBAR
		case WM_SETFOCUS:
			showTaskBar(false);
			return 0;

		case WM_KILLFOCUS:
			showTaskBar(true);
			return 0;
#endif

		case WM_ACTIVATE:
			DEBUGMSG (1, (L"received WM_ACTIVATE\r\n"));
			if ( (wParam == WA_INACTIVE) || (wParam == WA_CLICKACTIVE) ) 
				UnhookTaskBar(); 
			else 
				HookTaskBar(); 
			return 0;
		case WM_LBUTTONDOWN:
			break;
		case WM_MOUSEMOVE:
			break;
		case WM_LBUTTONUP:
		case WM_LBUTTONDBLCLK:
			point.x = LOWORD (lParam) ;
			point.y = HIWORD (lParam) ;
			ClientToScreen (hWnd, &point) ;

			TrackPopupMenu (hMenu, TPM_LEFTALIGN, point.x, point.y, 
						  0, hWnd, NULL) ;
			//PostQuitMessage(0);
			break;

		case WM_RBUTTONUP:
			break;

		case WM_SIZE:
			//reorderTaskBar(hWnd);
			if ( (wParam & SIZE_MINIMIZED) || (wParam & SIZE_RESTORED) ){
				DEBUGMSG (1, (L"received SIZE_MINIMIZED/SIZE_RESTORED\r\n"));
				return 0;
			}
			else{
				DEBUGMSG (1, (L"received WM_SIZE: 0x%08x\r\n", wParam));
			}

			return 0;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_HELP_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_OPTIONS:
					DialogBox(hInst, (LPCTSTR)IDD_OPTIONSDLG, hWnd, (DLGPROC)Options);
					break;
				case IDM_FILE_EXIT:
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:

			hMenu = LoadMenu (hInst, MAKEINTRESOURCE(IDM_POPUP)) ;
			hMenu = GetSubMenu (hMenu, 0) ;

			//start background thread
			hThread = CreateThread(NULL, 0, &ThreadProc, (LPVOID)hWnd, 0, &threadID);
			if (hThread == NULL){
				ULONG uErr = GetLastError();
				DEBUGMSG(1, (L"could not create thread!\r\nError: 0x%0x\r\n", uErr));
			}

			//hook
			HookTaskBar(); 

			static HBRUSH hbrBlack, hbrBackground, hbrRed, hbrYellow, hbrGreen, hbrUnknown, hbrOrange;
			static HPEN hPen;

			break;
		case WM_UPDATESIGNAL: //background thread message, signal is in wParam
			iSignal = (int)wParam;
			DEBUGMSG(1, (L"Received WM_UPDATESIGNAL: %i\n", iSignal));
			//force a wm_paint message
			RECT rtUpdate;
			GetClientRect(g_hWnd, &rtUpdate);
			InvalidateRect(g_hWnd, &rtUpdate, true);
			break;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rt); //get actual rect

			// ########### draw a bitmap ############
			// To paint with a DDB it first needs to be associated
			// with a memory device context. We make a DC that
			// is compatible with the screen by passing NULL to
			// CreateCompatibleDC.
			// Then we need to associate our saved bitmap with the
			// device context.
			hdcMem = CreateCompatibleDC(NULL);

			BITMAP bm;

			if(iSignal >= -100 && iSignal <=0){
				//  max_signal = -20 (dBm)
				//  disassociation_signal = -85 (dBm)
				percent = 100 - 80*(-20 - iSignal)/(-20 - -85);
				DEBUGMSG(1, (L"--->percent: %i\n", percent));
				if(percent==0){
					hbmOld = (HBITMAP) SelectObject(hdcMem, hbm0);
					//GetObject(hbm0,sizeof(BITMAP),&bm);
				}
				if(percent>0 && percent<=25){
					hbmOld = (HBITMAP) SelectObject(hdcMem, hbm1);
					//GetObject(hbm1,sizeof(BITMAP),&bm);
				}
				else if(percent>25 && percent<=50){
					hbmOld = (HBITMAP) SelectObject(hdcMem, hbm2);
					//GetObject(hbm2,sizeof(BITMAP),&bm);
				}
				else if(percent>50 && percent<=75){
					hbmOld = (HBITMAP) SelectObject(hdcMem, hbm3);
					//GetObject(hbm3,sizeof(BITMAP),&bm);
				}
				else if(percent>75 && percent<=100){
					hbmOld = (HBITMAP) SelectObject(hdcMem, hbm4);
					//GetObject(hbm4,sizeof(BITMAP),&bm);
				}
			}
			else
			{
				//we got an error
				hbmOld = (HBITMAP) SelectObject(hdcMem, hbmError);
			}

			GetObject(hbmError,sizeof(BITMAP),&bm);

			// Now, the BitBlt function is used to transfer the contents of the 
			// drawing surface from one DC to another. Before we can paint the
			// bitmap however we need to know how big it is. We call the GDI
			// function GetObject to get the relevent details.

			// calc for middle of rt
			x=(rt.right-rt.left)/2; x=x-(bm.bmWidth/2);
			y=(rt.bottom-rt.top)/2; y=y-(bm.bmHeight/2);

			//BitBlt(hdc, x, y, bm.bmWidth, bm.bmHeight, hdcMem,0,0,SRCCOPY);

			StretchBlt(hdc,1 ,1 ,FLOATWIDTH-1, FLOATHEIGHT-1, hdcMem,0,0,bm.bmWidth,bm.bmHeight,SRCCOPY);

			// Now, clean up. A memory DC always has a drawing
			// surface in it. It is created with a 1X1 monochrome
			// bitmap that we saved earlier, and need to put back
			// before we destroy it.
			SelectObject(hdcMem, hbmOld);

			DeleteDC(hdcMem);		
			ReleaseDC(hWnd, hdc);
			DeleteObject(hbmOld);

			EndPaint(hWnd, &ps);
			return 0;
		case WM_CLOSE:
		case WM_DESTROY:
			bRunThread=false;
			Sleep(500);
//			showTaskBar(true);
			
			UnhookTaskBar(); 

			DeleteObject(hbrBackground);
			DeleteObject(hbrRed);
			DeleteObject(hbrGreen);
			DeleteObject(hbrYellow);
			DeleteObject(hbrUnknown);
			DeleteObject(hbrOrange);
			DeleteObject(hbrBlack);
			DeleteObject(hPen);

			DeleteObject(hbmError); //bitmap handle
			DeleteObject(hbm0); //bitmap handle
			DeleteObject(hbm1); //bitmap handle
			DeleteObject(hbm2); //bitmap handle
			DeleteObject(hbm3); //bitmap handle
			DeleteObject(hbm4); //bitmap handle

			PostQuitMessage(0);
			return 0;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	RECT rt, rt1;
	int DlgWidth, DlgHeight;	// dialog width and height in pixel units
	int NewPosX, NewPosY;

	switch (message)
	{
		case WM_INITDIALOG:
			// trying to center the About dialog
			if (GetWindowRect(hDlg, &rt1)) {
				GetClientRect(GetParent(hDlg), &rt);
				DlgWidth	= rt1.right - rt1.left;
				DlgHeight	= rt1.bottom - rt1.top ;
				NewPosX		= (rt.right - rt.left - DlgWidth)/2;
				NewPosY		= (rt.bottom - rt.top - DlgHeight)/2;
				
				// if the About box is larger than the physical screen 
				if (NewPosX < 0) NewPosX = 0;
				if (NewPosY < 0) NewPosY = 0;
				SetWindowPos(hDlg, 0, NewPosX, NewPosY,
					0, 0, SWP_NOZORDER | SWP_NOSIZE);
			}
			return TRUE;

		case WM_COMMAND:
			if ((LOWORD(wParam) == IDOK) || (LOWORD(wParam) == IDCANCEL))
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// Mesage handler for the options dialog
LRESULT CALLBACK Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	RECT rt, rt1, rect;
	int DlgWidth, DlgHeight;	// dialog width and height in pixel units
	int NewPosX, NewPosY;

	HWND hScroll=NULL;
	SCROLLINFO scrInfo;
	int scrollCode;
	static int newPos=80, oldPos=80;
	RECT mainRect;

	switch (message)
	{
		case WM_INITDIALOG:
			//save old position of window
			GetWindowRect(g_hWnd, &mainRect);
			oldPos=mainRect.left;
			newPos=oldPos;
			DEBUGMSG(1, (L"Old Window pos is: %i\n", oldPos));

			GetClientRect(FindWindow(NULL, L"Desktop Window"), &rect);
			// trying to center the About dialog
			if (GetWindowRect(hDlg, &rt1)) {
				GetClientRect(GetParent(hDlg), &rt);
				DlgWidth	= rect.right-rect.left; //rt1.right - rt1.left;
				DlgHeight	= rect.bottom-rect.top;// rt1.bottom - rt1.top ;
				NewPosX		= 0;//(rt.right - rt.left - DlgWidth)/2;
				NewPosY		= 26;//(rt.bottom - rt.top - DlgHeight)/2;
				
				// if the About box is larger than the physical screen 
				if (NewPosX < 0) 
					NewPosX = 0;
				if (NewPosY < 0) 
					NewPosY = 0;
				SetWindowPos(hDlg, 0, NewPosX, NewPosY,
					0, 0, SWP_NOZORDER | SWP_NOSIZE);
			}
			hScroll=GetDlgItem(hDlg, IDC_SCROLLBAR1);
			
			scrInfo.cbSize=sizeof(SCROLLINFO);
			scrInfo.fMask=SIF_ALL;
			scrInfo.nMax=GetSystemMetrics(SM_CXSCREEN)-FLOATWIDTH;//, SM_CYSCREEN
			scrInfo.nMin=26;
			scrInfo.nPage=26; //large change
			scrInfo.nPos=oldPos;
			scrInfo.nTrackPos=oldPos;

			SetScrollInfo(hScroll, SB_CTL, &scrInfo, TRUE);
			return TRUE;
		case WM_HSCROLL:
			//is this the right scrollbar?
			hScroll=GetDlgItem(hDlg, IDC_SCROLLBAR1);
			if((HWND)lParam==hScroll){
				scrollCode=(int)LOWORD(wParam);
				
				//nPos=(int)HIWORD(wParam);

				ZeroMemory(&scrInfo, sizeof(scrInfo));
				scrInfo.cbSize=sizeof(SCROLLINFO);
				scrInfo.fMask=SIF_POS;

				if (!GetScrollInfo(hScroll, SB_CTL, &scrInfo) ){
					DEBUGMSG(1, (L"GetScrollInfo 1 failed. LastError=0x%0x\n", GetLastError()));
					return 1; // GetScrollInfo failed
				}
				else{
					newPos = scrInfo.nPos;
					DEBUGMSG(1, (L"GetScrollInfo 1 newPos before query=%i\n", newPos));
				}
				switch(scrollCode){
					case SB_PAGELEFT:
						newPos=scrInfo.nPos - FLOATWIDTH;
						break;
					case SB_PAGERIGHT:
						newPos=scrInfo.nPos + FLOATWIDTH;
						break;
					case SB_LINELEFT:
						newPos=scrInfo.nPos - 1;
						break;
					case SB_LINERIGHT:
						newPos=scrInfo.nPos + 1;
						break;
					case SB_THUMBPOSITION:
					case SB_THUMBTRACK:
					  // Initialize SCROLLINFO structure
 
						ZeroMemory(&scrInfo, sizeof(scrInfo));
						scrInfo.cbSize = sizeof(scrInfo);
						scrInfo.fMask = SIF_TRACKPOS;
 
					  // Call GetScrollInfo to get current tracking 
					  //    position in si.nTrackPos
 
						if (!GetScrollInfo(hScroll, SB_CTL, &scrInfo) ){
							DEBUGMSG(1, (L"GetScrollInfo 2 failed. LastError=0x%0x\n", GetLastError()));
							return 1; // GetScrollInfo failed
						}
						else
							newPos = scrInfo.nTrackPos;
						break;
				}
				if(newPos<0)
					newPos=0;
				if( newPos > (GetSystemMetrics(SM_CXSCREEN)-FLOATWIDTH) )
					newPos=GetSystemMetrics(SM_CXSCREEN)-FLOATWIDTH;

				DEBUGMSG(1, (L"Scrollbar: nPos=%i\n", newPos));
				SetScrollPos(hScroll, SB_CTL, newPos, TRUE);
				
				MoveWindow(g_hWnd, newPos, 0, FLOATWIDTH, FLOATHEIGHT, TRUE);
			}
			return TRUE;
		case WM_COMMAND:
			if ((LOWORD(wParam) == IDOK) || (LOWORD(wParam) == IDCANCEL))
			{
				if(LOWORD(wParam) == IDOK){
					//save the new pos to reg
					MoveWindow(g_hWnd, newPos, 0, FLOATWIDTH, FLOATHEIGHT, TRUE);
					saveReg(newPos);
				}
				if(LOWORD(wParam) == IDCANCEL){
					//restore oldPos
					MoveWindow(g_hWnd, oldPos, 0, FLOATWIDTH, FLOATHEIGHT, TRUE);
				}
				UpdateWindow(g_hWnd);
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
// TaskWndProc // 
// Handles the WM_LBUTTONUP message // 
LRESULT TaskWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) 
{ 
	if(msg == WM_LBUTTONUP) { 
		RECT rc; 
		POINT pt; 
		rc.left = 240 - 26; 
		rc.top = 0; 
		rc.bottom = 26; 
		rc.right = 240; 
		pt.x = LOWORD(lParam); 
		pt.y = HIWORD(lParam); 
		if(PtInRect(&rc, pt)) { 
			//PostMessage(g_hWnd, WM_CLOSE, 0, 0); 
			//simply do nothing
			return true;
			return CallWindowProc( g_fnProcTask, hWnd, WM_MOUSEMOVE, 0, MAKELPARAM(200, 0)); 
		} 
	} 
	return CallWindowProc(g_fnProcTask, hWnd, msg, wParam, lParam); 
}

