﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ClearDevice
{
    public partial class Form1 : Form
    {
        RemoveAllIcons removeIcons;
        bool needsReboot = false; //if you change the Home screen, a reboot is required
        public Form1()
        {
            InitializeComponent();
            removeIcons = new RemoveAllIcons();
            removeIcons.RaiseCustomEvent += new EventHandler<RemoveAllIcons.CustomEventArgs>(removeIcons_RaiseCustomEvent);
        }

        void removeIcons_RaiseCustomEvent(object sender, RemoveAllIcons.CustomEventArgs e)
        {
            addLog(e.Message);
        }


        private void button1_Click(object sender, EventArgs e)
        {
            chkHomeItems.Checked = true;
            chkSettingsIcons.Checked = true;
            chkStartMenu.Checked = true;
        }

        delegate void SetTextCallback(string text);
        public void addLog(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.txtLog.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(addLog);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                if (txtLog.Text.Length > 4000)
                    txtLog.Text = "";
                txtLog.Text += text + "\r\n";
                txtLog.SelectionLength = 0;
                txtLog.SelectionStart = txtLog.Text.Length - 1;
                txtLog.ScrollToCaret();
            }
        }
        private void showReboot()
        {
            if (MessageBox.Show("Changes to Today screen may require a reboot.", "Reboot now?", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
                win32.reboot();
        }
        private void mnuRestore_Click(object sender, EventArgs e)
        {
            restoreAll();
            if (needsReboot)
                showReboot();
        }
        void restoreAll()
        {
            addLog("Restoring StartMenu items...\r\n");
            addLog( removeIcons.restoreStartIcons().ToString() + " restored.\r\n");

            addLog("Restoring Home items...\r\n");
            addLog( removeIcons.restoreHomeItems().ToString() + " restored.\r\n");
            needsReboot = true;

            addLog("Restoring Settings icon...\r\n" );
            addLog(removeIcons.restoreSettingsIcon().ToString() + " restored.\r\n");
        }
        void removeAll()
        {
            addLog("Removing Home items...\r\n");
            addLog(removeIcons.removeHomeItems().ToString() + " removed.\r\n");

            addLog("Removing Start Menu items...\r\n" );
            addLog(removeIcons.removeStartMenuItems().ToString() + " removed.\r\n");
            needsReboot = true;

            addLog("Removing Settings icon...\r\n" );
            addLog(removeIcons.removeSettingsIcon().ToString() + " removed.\r\n");

        }
        private void btnClear_Click(object sender, EventArgs e)
        {
            needsReboot = false;
            if (chkHomeItems.Checked)
            {
                removeIcons.saveHomeItemSettings();

                addLog("Removing Home items...\r\n");
                addLog(removeIcons.removeHomeItems().ToString() + " removed.\r\n");
                needsReboot = true;
            }
            if (chkStartMenu.Checked)
            {
                addLog("Removing Start Menu items...\r\n");
                addLog(removeIcons.removeStartMenuItems().ToString() + " removed.\r\n");
            }
            if (chkSettingsIcons.Checked)
            {
                addLog("Removing Settings icon...\r\n");
                addLog(removeIcons.removeSettingsIcon().ToString() + " removed.\r\n");
            }
            if (needsReboot)
                showReboot();

        }

        private void btnRestore_Click(object sender, EventArgs e)
        {
            needsReboot = false;
            if(chkStartMenu.Checked){
                addLog("Restoring StartMenu items...\r\n");
                addLog(removeIcons.restoreStartIcons().ToString() + " restored.\r\n");}
            if (chkHomeItems.Checked)
            {
                addLog("Restoring Home items...\r\n");
                addLog(removeIcons.restoreHomeItems().ToString() + " restored.\r\n");
                needsReboot = true;
            }
            if (chkSettingsIcons.Checked)
            {
                addLog("Restoring Settings icon...\r\n");
                addLog(removeIcons.restoreSettingsIcon().ToString() + " restored.\r\n");
            }
            if (needsReboot)
                showReboot();
        }

        private void mnuRemoveAll_Click(object sender, EventArgs e)
        {
            removeAll();
            if (needsReboot)
                showReboot();
        }
    }
}