﻿using System;
using System.Collections.Generic;
using System.Text;

using System.IO;
using System.Xml;
using System.Xml.Serialization;
using System.Collections;

namespace ClearDevice
{
    [Serializable, XmlRoot("HomeEntries")]
    public class HomeEntries
    {
        [XmlElement("HomeEntry")]
        public List<HomeEntry> _list;

        public HomeEntries()
        {
            _list = new List<HomeEntry>();
        }
        public void add(HomeEntry he)
        {
            _list.Add(he);
        }
        public List<HomeEntry> getDefault()
        {
            _list.Clear();
            _list.Add(new HomeEntry("Windows Live", 1));
            _list.Add(new HomeEntry("Getting Started", 1));
            _list.Add(new HomeEntry("Internet Calling", 1));
            _list.Add(new HomeEntry("Messaging", 1));
            _list.Add(new HomeEntry("Tasks", 1));
            _list.Add(new HomeEntry("Calendar", 1));
            _list.Add(new HomeEntry("Device Lock", 1));
            _list.Add(new HomeEntry("Bing", 1));
            _list.Add(new HomeEntry("Date", 1));
            _list.Add(new HomeEntry("Enabled", 1));
            _list.Add(new HomeEntry("SessionTimeout", 4));
            return _list;
        }
        public Dictionary<string, Int32> getDict()
        {
            Dictionary<string, Int32> _dict = new Dictionary<string, int>();
            foreach (HomeEntry he in _list)
            {
                _dict.Add(he.name, he.DWORD);
            }
            return _dict;
        }
        public static HomeEntries deserialize(string sXMLfile)
        {
            XmlSerializer xs = new XmlSerializer(typeof(HomeEntries));
            //StreamReader sr = new StreamReader("./SystemHealth.xml");
            StreamReader sr = new StreamReader(sXMLfile);
            HomeEntries s=null;
            try
            {
                s = (HomeEntries)xs.Deserialize(sr);
            }
            catch (XmlException ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " in 'HomeEntries deserialize' " + ex.StackTrace);
                throw new Exception(ex.Message);
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " in 'HomeEntries deserialize' " + ex.StackTrace);
                throw new Exception(ex.Message);
            }
            sr.Close();
            return s;
        }
        public static void serialize(HomeEntries datamodel, string sXMLfile)
        {
            XmlSerializer xs = new XmlSerializer(typeof(HomeEntries));
            //omit xmlns:xsi from xml output
            //Create our own namespaces for the output
            XmlSerializerNamespaces ns = new XmlSerializerNamespaces();
            //Add an empty namespace and empty value
            ns.Add("", "");
            StreamWriter sw = new StreamWriter(sXMLfile);
            xs.Serialize(sw, datamodel, ns);
            sw.Flush();
            sw.Close();
        }

    }

    public class HomeEntry{
        [XmlElement("name")]
        public string name {get; set;}
        [XmlElement("value")]
        public Int32 DWORD { get; set; }

        //to avoid excpetion in deserialize '{"ClearDevice.HomeEntry cannot be serialized because it does not have a parameterless constructor."}'
        internal HomeEntry()
        {
            name = "";
            DWORD = 0;
        }
        public HomeEntry(string sname, Int32 iValue)
        {
            name = sname;
            DWORD = iValue;
        }
        public override string ToString()
        {
            return name + ":" + DWORD.ToString();
        }

    }
}
