﻿using System;

using System.Collections.Generic;
using System.Text;

using Microsoft.Win32;
using System.IO;
using System.IO.Compression;

using System.Runtime.InteropServices;
using Ionic.Zip;

namespace ClearDevice
{
    public class RemoveAllIcons:System.Windows.Forms.Control
    {
        public string _sProgramsDir="\\Windows\\Start Menu\\Programs";
        //string zipFile = @"\backup.zip";
        string zipFileName=@"\backup.zip";
        public RemoveAllIcons()
        {
            string sProgStartMenuDir = shellFolders.getProgramsDir();
            if (System.IO.Directory.Exists(_sProgramsDir))
                _sProgramsDir = sProgStartMenuDir;
        }
        #region event_stuff
        public delegate void CustomEventHandler(object sender, CustomEventArgs a);
        public event EventHandler<CustomEventArgs> RaiseCustomEvent;
        public class CustomEventArgs : EventArgs
        {
            public CustomEventArgs(string s)
            {
                msg = s;
            }
            private string msg;
            public string Message
            {
                get { return msg; }
                set { msg = value; }
            }
        }
        // Wrap event invocations inside a protected virtual method
        // to allow derived classes to override the event invocation behavior
        delegate void setRaiseEvent(CustomEventArgs e);
        protected virtual void OnRaiseCustomEvent(CustomEventArgs e)
        {
            if (this.InvokeRequired)
            {
                setRaiseEvent d = new setRaiseEvent(OnRaiseCustomEvent);
                this.Invoke(d, new object[] { e });
            }
            else
            {
                if (this.RaiseCustomEvent != null)
                {
                    this.RaiseCustomEvent(this, e);
                }
            }
        }

        #endregion

        //subscribed zip events
        void dZip_RaiseCustomEvent(object sender, RemoveAllIcons.CustomEventArgs e)
        {
            this.OnRaiseCustomEvent(new CustomEventArgs(e.Message));
        }

        public int removeStartMenuItems()
        {
            int iRet = 0;
            string[] subDirs = null;
            subDirs = System.IO.Directory.GetDirectories(_sProgramsDir);
            
            zipFiles(_sProgramsDir);

            foreach (string s in subDirs)
            {
                iRet += removeStartIcons(s);
                try
                {
                    System.IO.Directory.Delete(s);
                }
                catch (Exception) { }
            }
            //current dir
            iRet += removeStartIcons(_sProgramsDir);
            return iRet;
        }
        public int restoreStartIcons()
        {
            int iRet = unzipFiles(_sProgramsDir);
            return iRet;
        }
        int removeStartIcons(string subDir)
        {
            int iRet = 0;
            string[] sFiles=null;
            try
            {
                sFiles = System.IO.Directory.GetFiles(subDir, "*.*");
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " getting files '" + subDir + "'");
            }
            foreach (string s in sFiles)
            {
                try
                {
                    win32.SetFileAttributes(s, win32.FileAttributes.Normal);
                    File.Delete(s);
                    OnRaiseCustomEvent(new CustomEventArgs("Deleting file '" + s + "' OK"));
                    iRet++;
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " deleting file '" + s + "'");
                    OnRaiseCustomEvent(new CustomEventArgs("Deleting file '" + s + "' failed"));
                }
            }
            return iRet;
        }
        #region SaveRestoreHomeSettingsStuff
        public int saveHomeItemSettings()
        {
            if (System.IO.File.Exists(@"\backup.xml"))
                if (System.Windows.Forms.MessageBox.Show("Backup file already exists. Overwrite?", "Home items backup", System.Windows.Forms.MessageBoxButtons.YesNo, System.Windows.Forms.MessageBoxIcon.Question, System.Windows.Forms.MessageBoxDefaultButton.Button2) == System.Windows.Forms.DialogResult.No)
                    return 0;

            int iRet = 0;
            List<HomeEntry> _HomeEntries = new List<HomeEntry>();
            RegistryKey key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today\Items", false);
            string[] sSubKeys = key.GetSubKeyNames();
            Int32 i32;
            foreach (string s in sSubKeys)
            {
                try
                {
                    i32 = (Int32) (key.OpenSubKey(s).GetValue("Enabled", 1));
                    HomeEntry newEntry= new HomeEntry(s,i32);
                    _HomeEntries.Add(newEntry);
                    System.Diagnostics.Debug.WriteLine("Added '"+ newEntry +"' OK");
                    iRet++;
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " getting '" + s + "'");
                }
            }
            key.Close();
            //disable Date in Today list
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today", false);
            try
            {
                i32 =(Int32) key.GetValue("Date", 0);
                HomeEntry newEntry= new HomeEntry("Date",i32);
                _HomeEntries.Add(newEntry);
                System.Diagnostics.Debug.WriteLine("Added 'Date' OK");
                iRet++;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " getting 'Date'");
            }
            //disable Today Enabled:0
            //disable Date in Today list
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today", false);
            try
            {
                i32 =(Int32) key.GetValue("Enabled", 0);
                HomeEntry newEntry = new HomeEntry("Enabled", i32);
                _HomeEntries.Add(newEntry);
                System.Diagnostics.Debug.WriteLine("Added 'Enabled' OK");
                iRet++;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " getting 'Enabled'");
            }
            //disable Today popup
            key.Close();
            //HKEY_LOCAL_MACHINE\Software\Microsoft\Shell\Rai:SessionTimeout
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Shell\Rai", true);
            try
            {
                i32 =(Int32) key.GetValue("SessionTimeout", 0);
                HomeEntry newEntry = new HomeEntry("SessionTimeout", i32);
                _HomeEntries.Add(newEntry);
                System.Diagnostics.Debug.WriteLine("Added 'SessionTimeout' OK");
                iRet++;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " getting 'SessionTimeout'");
            }
            key.Close();

            //save settings to xml
            HomeEntries entries = new HomeEntries();
            entries._list = _HomeEntries;
            //foreach (HomeEntry he in _HomeEntries)
            //    entries.add(he);
            try
            {
                HomeEntries.serialize(entries, @"\backup.xml");
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " in HomeEntries.serialize()");
                iRet = -1;
            }
            return iRet;
        }
        #endregion

        public int removeHomeItems()
        {
            int iRet = 0;
            RegistryKey key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today\Items",true);
            string[] sSubKeys = key.GetSubKeyNames();
            foreach (string s in sSubKeys)
            {
                try
                {
                    key.OpenSubKey(s,true).SetValue("Enabled", 0, RegistryValueKind.DWord);
                    System.Diagnostics.Debug.WriteLine("Setting Enabled=0 for '" + s + "' OK");
                    OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=0 for '" + s + "' OK"));
                    iRet++;
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=0 for '" + s + "'");
                    OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=0 for '" + s + "' failed"));
                }
            }
            key.Close();
            //disable Date in Today list
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today", true);
            try
            {
                key.SetValue("Date", 0, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=0 for 'Date' OK"));
                System.Diagnostics.Debug.WriteLine("Setting Enabled=0 for 'Date' OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=0 for 'Date' failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=0 for 'Date'");
            }
            //disable Today at all
            try
            {
                key.SetValue("Enabled", 0, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting Today:Enabled=0 OK"));
                System.Diagnostics.Debug.WriteLine("Setting Today:Enabled=0 OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting Today:Enabled=0 failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=0 for 'Today'");
            }
            //disable Today popup after time x
            key.Close();
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today", true);
            try
            {
                key.SetValue("Date", 0, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=0 for 'Date' OK"));
                System.Diagnostics.Debug.WriteLine("Setting Enabled=0 for 'Date' OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=0 for 'Date' failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=0 for 'Date'");
            }
            //disable Today at all
            key.Close();
            //HKEY_LOCAL_MACHINE\Software\Microsoft\Shell\Rai:SessionTimeout
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Shell\Rai", true);
            try
            {
                key.SetValue("SessionTimeout", 0, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting SessionTimeout=0 OK"));
                System.Diagnostics.Debug.WriteLine("Setting SessionTimeout=0 OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting SessionTimeout=0 failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting SessionTimeout=0");
            }
            key.Close();
            return iRet;
        }
        public int restoreHomeItems()
        {
            HomeEntries he= new HomeEntries();
            List<HomeEntry> _list = new List<HomeEntry>();
            if (!System.IO.File.Exists(@"\backup.xml"))
            {
                //no backup exists, applaying default
                _list = he.getDefault();
            }
            else
            {
                try
                {
                    he = HomeEntries.deserialize(@"\backup.xml");
                    _list = he._list;
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting restoreHomeItems. Using default list");
                    _list = he.getDefault();
                }
            }
            Dictionary<string, Int32> _dict;
            //copy local list (default or from backup) into object
            he._list=_list;
            _dict = he.getDict();// get a searchable dictionary

            int iRet = 0;
            RegistryKey key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today\Items",true);
            string[] sSubKeys = key.GetSubKeyNames();
            Int32 dwValue = 0;
            foreach (string s in sSubKeys)
            {
                try
                {
                    if (!_dict.TryGetValue(s, out dwValue))
                        dwValue = 1;
                    key.OpenSubKey(s,true).SetValue("Enabled", dwValue, RegistryValueKind.DWord);
                    System.Diagnostics.Debug.WriteLine("Setting Enabled="+dwValue.ToString()+" for '" + s + "' OK");
                    OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=" + dwValue.ToString() + " for '" + s + "' OK"));
                    iRet++;
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=" + dwValue.ToString() + " for '" + s + "'");
                    OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=" + dwValue.ToString() + " for '" + s + "' failed"));
                }
            }
            key.Close();
            //enable Date in Today list
            key=Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Today",true);
            try
            {
                if (!_dict.TryGetValue("Date", out dwValue))
                    dwValue = 1;
                key.SetValue("Date", dwValue, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=" + dwValue.ToString() + " for 'Date' OK"));
                System.Diagnostics.Debug.WriteLine("Setting Enabled=" + dwValue.ToString() + " for 'Date' OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting Enabled=" + dwValue.ToString() + " for 'Date' failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=" + dwValue.ToString() + " for 'Date'");
            }
            //enable Today at all
            try
            {
                if (!_dict.TryGetValue("Enabled", out dwValue))
                    dwValue = 1;
                key.SetValue("Enabled", dwValue, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting Today:Enabled=" + dwValue.ToString() + " OK"));
                System.Diagnostics.Debug.WriteLine("Setting Today:Enabled=" + dwValue.ToString() + " OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting Today:Enabled=" + dwValue.ToString() + " failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting Enabled=" + dwValue.ToString() + " for 'Today'");
            }
            key.Close();
            //enable Today after 4 hours
            key.Close();
            //HKEY_LOCAL_MACHINE\Software\Microsoft\Shell\Rai:SessionTimeout
            key = Registry.LocalMachine.OpenSubKey(@"Software\Microsoft\Shell\Rai", true);
            try
            {
                if (!_dict.TryGetValue("SessionTimeout", out dwValue))
                    dwValue = 1;
                key.SetValue("SessionTimeout", dwValue, RegistryValueKind.DWord);
                OnRaiseCustomEvent(new CustomEventArgs("Setting SessionTimeout=" + dwValue.ToString() + " OK"));
                System.Diagnostics.Debug.WriteLine("Setting SessionTimeout=" + dwValue.ToString() + " OK");
                iRet++;
            }
            catch (Exception ex)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Setting SessionTimeout=" + dwValue.ToString() + " failed"));
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting SessionTimeout=" + dwValue.ToString() + "");
            }
            return iRet;
        }
        public int restoreSettingsIcon()
        {
            int iRet = 0;
            RegistryKey key = Registry.LocalMachine.OpenSubKey(@"Security\Shell\StartInfo",true);
            try
            {
                key.SetValue("HideSettings", 0, RegistryValueKind.DWord);
                System.Diagnostics.Debug.WriteLine("Setting HideSettings=0 OK");
                OnRaiseCustomEvent(new CustomEventArgs("Setting HideSettings=0 OK"));
                iRet++;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting HideSettings=0");
                OnRaiseCustomEvent(new CustomEventArgs("Setting HideSettings=0 failed"));
            }
            return iRet;

        }

        public int removeSettingsIcon()
        {
            int iRet = 0;
            RegistryKey key = Registry.LocalMachine.OpenSubKey(@"Security\Shell\StartInfo",true);
            try
            {
                key.SetValue("HideSettings", 1, RegistryValueKind.DWord);
                System.Diagnostics.Debug.WriteLine("Setting HideSettings=1 OK");
                OnRaiseCustomEvent(new CustomEventArgs("Setting HideSettings=1 OK"));
                iRet++;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception " + ex.Message + " setting HideSettings=1");
                OnRaiseCustomEvent(new CustomEventArgs("Setting HideSettings=1 failed"));
            }
            return iRet;

        }
        //#########################################################################################
        #region ZIP_Stuff
        private int zipFiles(string sDir)
        {
            int iRet = 0;
            if (System.IO.File.Exists(zipFileName))
                if (System.Windows.Forms.MessageBox.Show("Zip file '" + zipFileName + "' already exists. Overwrite?", "Overwrite?", System.Windows.Forms.MessageBoxButtons.YesNo, System.Windows.Forms.MessageBoxIcon.Question, System.Windows.Forms.MessageBoxDefaultButton.Button2) == System.Windows.Forms.DialogResult.No)
                    return 0;
                else
                    System.IO.File.Delete(zipFileName);

            if (!System.IO.Directory.Exists(sDir))
                return 0;

            System.IO.StreamWriter sw = new System.IO.StreamWriter(zipFileName + ".log");
            ZipFile zip = new ZipFile(zipFileName, sw);
            zip.ZipError += new EventHandler<ZipErrorEventArgs>(zip_ZipError);
            zip.ZipErrorAction = ZipErrorAction.Skip;
            zip.StatusMessageTextWriter = sw;
            zip.AddProgress += new EventHandler<AddProgressEventArgs>(zip_AddProgress);
            try
            {
                ZipEntry ze = zip.AddDirectory(sDir);
                System.Diagnostics.Debug.WriteLine("zip: added '" + sDir + "'");
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Exception: " + ex.Message);
            }
            iRet = zip.Entries.Count;
            zip.Save(zipFileName);
            zip.Dispose();
            sw.Close();
            return iRet;
        }

        void zip_AddProgress(object sender, AddProgressEventArgs e)
        {
            if (e.EventType == ZipProgressEventType.Adding_AfterAddEntry)
            {
                OnRaiseCustomEvent(new CustomEventArgs("Added " + e.CurrentEntry.FileName));
            }
        }

        int unzipFiles(string sUnzipDir)
        {
            if (!System.IO.File.Exists(zipFileName))
                return 0;

            System.IO.StreamWriter sw = new System.IO.StreamWriter(@"\backup.unzip.log");
            ZipFile zip = new ZipFile(zipFileName);
            zip.ZipError += new EventHandler<ZipErrorEventArgs>(zip_ZipError);
            zip.ZipErrorAction = ZipErrorAction.Skip;
            zip.StatusMessageTextWriter = sw;
            zip.ExtractProgress += new EventHandler<ExtractProgressEventArgs>(zip_ExtractProgress);

            zip.ExtractAll(sUnzipDir, ExtractExistingFileAction.DoNotOverwrite);
            
            zip.Dispose();
            sw.Close();
            return zip.Entries.Count;
        }

        void zip_ExtractProgress(object sender, ExtractProgressEventArgs e)
        {
            if (e.CurrentEntry != null)
            {
                if (e.EventType == ZipProgressEventType.Extracting_AfterExtractEntry)
                {
                    OnRaiseCustomEvent(new CustomEventArgs("Extracted: " + e.CurrentEntry.FileName));
                    System.Diagnostics.Debug.WriteLine("zip_ExtractProgress: " + e.CurrentEntry.FileName);
                }
            }
        }

        void zip_ZipError(object sender, ZipErrorEventArgs e)
        {
            System.Diagnostics.Debug.WriteLine("ziperror: " + e.Exception);
        }
        #endregion
    }

    public static class win32
    {
        [DllImport("coredll.dll")]
        public static extern bool SetFileAttributes(string lpFileName, FileAttributes dwFileAttributes);
        [Flags]
        public enum FileAttributes : uint
        {
            Readonly = 0x00000001,
            Hidden = 0x00000002,
            System = 0x00000004,
            Directory = 0x00000010,
            Archive = 0x00000020,
            Device = 0x00000040,
            Normal = 0x00000080,
            Temporary = 0x00000100,
            SparseFile = 0x00000200,
            ReparsePoint = 0x00000400,
            Compressed = 0x00000800,
            Offline = 0x00001000,
            NotContentIndexed = 0x00002000,
            Encrypted = 0x00004000,
            Write_Through = 0x80000000,
            Overlapped = 0x40000000,
            NoBuffering = 0x20000000,
            RandomAccess = 0x10000000,
            SequentialScan = 0x08000000,
            DeleteOnClose = 0x04000000,
            BackupSemantics = 0x02000000,
            PosixSemantics = 0x01000000,
            OpenReparsePoint = 0x00200000,
            OpenNoRecall = 0x00100000,
            FirstPipeInstance = 0x00080000
        }

        const int POWER_STATE_RESET = 0x800000;
        [DllImport("coredll.dll")]
        public static extern Int32 SetSystemPowerState(System.Char[] psState, System.Int32 StateFlags, System.Int32 Options);
        public static void reboot()
        {
            SetSystemPowerState(null, POWER_STATE_RESET, 0);
        }
    }
    public class shellFolders
    {
        public static string getProgramsDir()
        {
            StringBuilder resultPath = new StringBuilder(255);
            SHGetSpecialFolderPath((IntPtr)0, resultPath, CSIDL.CSIDL_PROGRAMS, 0);
            return resultPath.ToString();
        }
        [DllImport("coredll.dll")]
        static extern int SHGetSpecialFolderPath(IntPtr hwndOwner, StringBuilder lpszPath, CSIDL nFolder, int fCreate);
        /*
            //-------------------------------------------------------------------------
            //
            // SHGetSpecialFolderLocation
            //
            //  Caller should call SHFree to free the returned pidl.
            //
            //-------------------------------------------------------------------------
            //
            // registry entries for special paths are kept in :
            #define REGSTR_PATH_SPECIAL_FOLDERS    REGSTR_PATH_EXPLORER "\\Shell Folders"

            #define CSIDL_PROGRAMS           0x0002
            #define CSIDL_CONTROLS           0x0003
            #define CSIDL_PRINTERS           0x0004
            #define CSIDL_PERSONAL           0x0005
            #define CSIDL_FAVORITES          0x0006
            #define CSIDL_STARTUP            0x0007
            #define CSIDL_RECENT             0x0008
            #define CSIDL_SENDTO             0x0009
            #define CSIDL_BITBUCKET          0x000a
            #define CSIDL_STARTMENU          0x000b
            #define CSIDL_MYMUSIC            0x000d
            #define CSIDL_DESKTOPDIRECTORY   0x0010
            #define CSIDL_DRIVES             0x0011		
            #define CSIDL_NETWORK            0x0012
            #define CSIDL_NETHOOD            0x0013
            #define CSIDL_FONTS		 0x0014
            #define CSIDL_TEMPLATES          0x0015
            #define CSIDL_APPDATA                   0x001a

            WINSHELLAPI HRESULT WINAPI SHGetSpecialFolderLocation(HWND hwndOwner, int nFolder, LPITEMIDLIST * ppidl);
        */
        //Diferent folders to use.
        enum CSIDL{
            CSIDL_DESKTOP = 0x0000, //Not supported on Smartphone.
            CSIDL_FAVORITES = 0x0006, //The file system directory that serves as a common repository for the user's favorite items.
            CSIDL_FONTS = 0x0014, //The virtual folder that contains fonts.
            CSIDL_PERSONAL = 0x0005, //The file system directory that serves as a common repository for documents.
            CSIDL_PROGRAM_FILES = 0x0026, //The program files folder.
            CSIDL_PROGRAMS = 0x0002, //The file system directory that contains the user's program groups, which are also file system directories.
            CSIDL_STARTUP = 0x0007, //The file system directory that corresponds to the user's Startup program group. The system starts these programs when a device is powered on.
            CSIDL_WINDOWS = 0x0024, //The Windows folder.
        };
    }
}
